package com.xforceplus.ant.system.client.model.goods;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Describe: 商品审核记录查询 响应
 *
 * @Author xiezhongyong
 * @Date 2022-07-18
 */
@Data
public class GetGoodsRecordResp {

    @ApiModelProperty("数据ID(使用商品原生信息补全时无ID数据)")
    private Long id;

    @ApiModelProperty("商品编码")
    private String goodsNo;

    @ApiModelProperty(value = "审核状态(0:初始状态，未找到审核数据，1:审核中)")
    private Integer approveStatus;

    @ApiModelProperty(value = "商品 属性审核字段列表")
    private List<AuditField> auditFields;

    @Data
    public static class AuditField {
        @ApiModelProperty("字段名")
        private String fieldName;
        @ApiModelProperty("字段值")
        private String fieldValue;
        @ApiModelProperty("字段审核值")
        private String fieldAuditValue;
    }

}
