package com.xforceplus.ant.system.client.model.goods;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * Describe: 商品基础信息、销方商品信息，购方商品信息
 * PS: 不考虑中台商品的全量字段，这些字段协同内部服务调用够用就行
 * @Author xiezhongyong
 * @Date 2021-12-03
 */
@Data
public class GoodsInfo {
    @ApiModelProperty("商品ID")
    private Long goodsId;
    @ApiModelProperty("商品名称")
    private String goodsName;
    @ApiModelProperty("商品编码")
    private String goodsNo;
    @ApiModelProperty("规格型号")
    private String specification;
    @ApiModelProperty("单位")
    private String quantityUnit;
    @ApiModelProperty("单价")
    private String unitPrice;
    @ApiModelProperty("计价方式, 0 = 不含税，1=含税")
    private Integer priceMethod;
    @ApiModelProperty("税编Id")
    private Long taxId;
    @ApiModelProperty("税编名称")
    private String taxName;
    @ApiModelProperty("税收编码")
    private String taxCode;
    @ApiModelProperty("税编简称")
    private String taxShortName;
    @ApiModelProperty("税率")
    private String taxRate;
    @ApiModelProperty("是否享受优惠政策， 0 否， 1 是")
    private String taxPre;
    @ApiModelProperty("优惠政策内容")
    private String taxPreCon;
    @ApiModelProperty("零税率标识， 0 出口退税， 1 免税，2 不征税， 2 普通零税率")
    private String zeroTax;
    @ApiModelProperty("公司名称")
    private String companyName;
    @ApiModelProperty("公司税号")
    private String companyTaxNo;
    @ApiModelProperty("公司id")
    private Long companyId;

    /**
     * 销方商品属性扩展
     */
    @Data
    public static class Seller extends GoodsInfo{

    }
    /**
     * 购方商品属性扩展
     */
    @Data
    public static class Purchaser extends GoodsInfo{
        @ApiModelProperty("购方租户ID")
        private Long purchaserTenantId;
        @ApiModelProperty("购方租户CODE")
        private String purchaserTenantCode;
    }
}
