package com.xforceplus.ant.system.client.model.goods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.ant.system.client.model.MsGoodsModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Describe: 商品列表响应
 *
 * @Author xiezhongyong
 * @Date 2022/6/7
 */
@Data
public class ListGoodsReq {

    @ApiModelProperty("自有或协同公司Id，根据type值区分")
    private Long companyId;

    @ApiModelProperty("协同商品编号")
    private String cooperatorGoodsNo;

    @ApiModelProperty("协同税号")
    private String cooperatorTaxNo;

    @ApiModelProperty("协同商品租户Id")
    private Long cooperatorTenantId;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("商品编号")
    private String goodsNo;

    @ApiModelProperty("是否有协同商品")
    private Boolean hasCooperator;

    @ApiModelProperty("返回商品信息 0=不返回映射数据 1=返回映射数据")
    private Integer returnType;

    @ApiModelProperty("商品类型, 0=自有商品 1=协同商品")
    private Integer type;

    @ApiModelProperty("租户ID")
    private Long tenantId;

    @ApiModelProperty("页码")
    private Integer pageNo;

    @ApiModelProperty("每页数量")
    private Integer pageSize;

    @ApiModelProperty("商品税率")
    private String taxRate;


}
