package com.xforceplus.ant.system.client.model.sso;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * Describe: 运维平台单点登录url 获取
 *
 * @Author xiezhongyong
 * @Date 2022-09-02
 */
@Data
public class OpsSsoUrlGetRequest {

    @ApiModelProperty("ossUrl用户ID")
    @NotNull(message = "ossUrl用户ID 不能为空")
    private Long ossUrlUserId;

    @ApiModelProperty("操作用户ID")
    @NotNull(message = "操作用户ID 不能为空")
    private Long opUserId;


    @ApiModelProperty("操作用户名")
    @NotEmpty(message = "操作用户名 不能为空")
    private String opUserName;
}
