package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsConfigGetCmpTenantIdResponse;
import com.xforceplus.ant.system.client.model.MsConfigGetSysCodeRequest;
import com.xforceplus.ant.system.client.model.MsConfigGetSysCodeResponse;
import com.xforceplus.ant.system.client.model.MsCreatePurchaserSyscodeRequest;
import com.xforceplus.ant.system.client.model.MsResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "config", description = "the config API")
public interface ConfigApi {

    @ApiOperation(value = "生成购方小代码配置", notes = "", response = MsResponse.class, tags={ "Config", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/config/createPurchaserSyscode",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse createPurchaserSyscode(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsCreatePurchaserSyscodeRequest request);


    @ApiOperation(value = "获取公司多租户ID配置", notes = "", response = MsConfigGetCmpTenantIdResponse.class, tags={ "Config", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsConfigGetCmpTenantIdResponse.class) })
    @RequestMapping(value = "/config/getCmpTenantId",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsConfigGetCmpTenantIdResponse getCmpTenantId( @NotNull @ApiParam(value = "公司ID", required = true) @RequestParam(value = "cmpId", required = true) String cmpId);


    @ApiOperation(value = "获取小代码", notes = "", response = MsConfigGetSysCodeResponse.class, tags={ "Config", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsConfigGetSysCodeResponse.class) })
    @RequestMapping(value = "/config/getSysCode",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsConfigGetSysCodeResponse getSysCode(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsConfigGetSysCodeRequest request);

}
