package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsBacklogCountResponse;
import com.xforceplus.ant.system.client.model.MsBillPaymentResponse;
import com.xforceplus.ant.system.client.model.MsBillPaymentStatisticResponse;
import com.xforceplus.ant.system.client.model.MsBillStatisticResponse;
import com.xforceplus.ant.system.client.model.MsClearBacklogRequest;
import com.xforceplus.ant.system.client.model.MsHomepageVerModel;
import com.xforceplus.ant.system.client.model.MsInvoiceStatisticResponse;
import com.xforceplus.ant.system.client.model.MsOpHomepageVerRequest;
import com.xforceplus.ant.system.client.model.MsQueryBacklogRequest;
import com.xforceplus.ant.system.client.model.MsQueryBillPaymentModel;
import com.xforceplus.ant.system.client.model.MsResetBacklogRequest;
import com.xforceplus.ant.system.client.model.MsResponse;
import com.xforceplus.ant.system.client.model.MsStatisticByTypeRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "homepage", description = "the homepage API")
public interface HomepageApi {

    @ApiOperation(value = "统计待办事项", notes = "", response = MsBacklogCountResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsBacklogCountResponse.class) })
    @RequestMapping(value = "/homepage/backlogCount",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsBacklogCountResponse backlogCount(@ApiParam(value = "请求参数"  ) @RequestBody MsQueryBacklogRequest queryBacklogRequest);


    @ApiOperation(value = "统计年度结算单付款金额", notes = "", response = MsBillPaymentStatisticResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsBillPaymentStatisticResponse.class) })
    @RequestMapping(value = "/homepage/billPaymentStatistic",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsBillPaymentStatisticResponse billPaymentStatistic(@ApiParam(value = "请求参数"  ) @RequestBody MsQueryBillPaymentModel request);


    @ApiOperation(value = "结算单金额图表统计", notes = "", response = MsResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/homepage/bill-statistic/{purTenantId}/{sellerTaxNo}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse billStatistic(@ApiParam(value = "购方租户ID",required=true ) @PathVariable("purTenantId") Long purTenantId,@ApiParam(value = "销方税号",required=true ) @PathVariable("sellerTaxNo") String sellerTaxNo, @NotNull @ApiParam(value = "月份 格式YYYYMM  如202110", required = true) @RequestParam(value = "month", required = true) String month, @NotNull @ApiParam(value = "统计类型 0-正数结算单(默认) 1-负数结算单", required = true) @RequestParam(value = "statisticType", required = true) Integer statisticType);


    @ApiOperation(value = "首页结算单统计", notes = "", response = MsBillStatisticResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsBillStatisticResponse.class) })
    @RequestMapping(value = "/homepage/billStatisticByType",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsBillStatisticResponse billStatisticByType(@ApiParam(value = "统计请求信息" ,required=true ) @RequestBody MsStatisticByTypeRequest request);


    @ApiOperation(value = "变更用户使用首页版本", notes = "", response = MsResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/homepage/changeHomepageV",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse changeHomepageV(@ApiParam(value = "" ,required=true ) @RequestBody MsHomepageVerModel request);


    @ApiOperation(value = "处理待办事项", notes = "", response = MsResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/homepage/clearBacklog",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse clearBacklog(@ApiParam(value = "请求参数"  ) @RequestBody MsClearBacklogRequest clearBacklogRequest);


    @ApiOperation(value = "系统初始化待办完成", notes = "", response = MsResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/homepage/finishUserTask",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse finishUserTask( @NotNull @ApiParam(value = "租户id", required = true) @RequestParam(value = "tenantId", required = true) Long tenantId, @NotNull @ApiParam(value = "用户id", required = true) @RequestParam(value = "opUserId", required = true) Long opUserId, @ApiParam(value = "用户名称") @RequestParam(value = "opUserName", required = false) String opUserName);


    @ApiOperation(value = "首页发票头部统计", notes = "", response = MsResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/homepage/invoice-head/{purTenantId}/{sellerTaxNo}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse invoiceHead(@ApiParam(value = "购方租户ID",required=true ) @PathVariable("purTenantId") Long purTenantId,@ApiParam(value = "销方税号",required=true ) @PathVariable("sellerTaxNo") String sellerTaxNo, @ApiParam(value = "统计类型(非必填)  common-标准(默认)  inFillBill-获取回填中结算单号 failFillBill-回填失败结算单号") @RequestParam(value = "staticType", required = false) String staticType);


    @ApiOperation(value = "发票金额份数图表统计", notes = "", response = MsResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/homepage/invoice-statistic/{purTenantId}/{sellerTaxNo}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse invoiceStatistic(@ApiParam(value = "购方租户ID",required=true ) @PathVariable("purTenantId") Long purTenantId,@ApiParam(value = "销方税号",required=true ) @PathVariable("sellerTaxNo") String sellerTaxNo, @NotNull @ApiParam(value = "开始月份 格式YYYYMM  如202101", required = true) @RequestParam(value = "startMonth", required = true) String startMonth, @NotNull @ApiParam(value = "结束月份 格式YYYYMM  如202111", required = true) @RequestParam(value = "endMonth", required = true) String endMonth, @NotNull @ApiParam(value = "统计类型 0-总数(默认) 1-作废", required = true) @RequestParam(value = "statisticType", required = true) Integer statisticType);


    @ApiOperation(value = "首页发票统计", notes = "", response = MsInvoiceStatisticResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsInvoiceStatisticResponse.class) })
    @RequestMapping(value = "/homepage/invoiceStatisticByType",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsInvoiceStatisticResponse invoiceStatisticByType(@ApiParam(value = "统计请求信息" ,required=true ) @RequestBody MsStatisticByTypeRequest request);


    @ApiOperation(value = "批量新增、修改或删除用户首页版本信息", notes = "", response = MsResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/homepage/opUsersHomepageV",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse opUsersHomepageV(@ApiParam(value = "request" ,required=true ) @RequestBody MsOpHomepageVerRequest opRequest);


    @ApiOperation(value = "查询待办事项", notes = "", response = MsResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/homepage/queryBacklog",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse queryBacklog(@ApiParam(value = "请求参数"  ) @RequestBody MsQueryBacklogRequest queryBacklogRequest);


    @ApiOperation(value = "查询待办事项", notes = "", response = MsResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/homepage/queryBacklogCount",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse queryBacklogCount(@ApiParam(value = "请求参数"  ) @RequestBody MsQueryBacklogRequest queryBacklogRequest);


    @ApiOperation(value = "统计时间段结算单付款金额", notes = "", response = MsBillPaymentResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsBillPaymentResponse.class) })
    @RequestMapping(value = "/homepage/queryBillPayment",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsBillPaymentResponse queryBillPayment(@ApiParam(value = "请求参数"  ) @RequestBody MsQueryBillPaymentModel request);


    @ApiOperation(value = "查询首页版本", notes = "", response = MsResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/homepage/queryHomepageV",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse queryHomepageV(@ApiParam(value = "" ,required=true ) @RequestBody MsHomepageVerModel request);


    @ApiOperation(value = "重置待办事项", notes = "", response = MsResponse.class, tags={ "Homepage", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/homepage/resetBacklog",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse resetBacklog(@ApiParam(value = "请求参数"  ) @RequestBody MsResetBacklogRequest request);

}
