package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsQueryAuthLoginResponse;
import com.xforceplus.ant.system.client.model.MsResponse;
import com.xforceplus.ant.system.client.model.MsSetAuthLoginRequest;
import com.xforceplus.ant.system.client.model.MsSsoApplyChangeCmpNameRequest;
import com.xforceplus.ant.system.client.model.MsSsoGetUserAccessTokenRequest;
import com.xforceplus.ant.system.client.model.MsSsoGetUserIdRequest;
import com.xforceplus.ant.system.client.model.MsSsoGetUserIdResponse;
import com.xforceplus.ant.system.client.model.MsSsoResponse;
import com.xforceplus.ant.system.client.model.MsSsoSendSmsLoginCodeRequest;
import com.xforceplus.ant.system.client.model.MsSsoSendSmsLoginCodeResponse;
import com.xforceplus.ant.system.client.model.MsSsoValidateSmsLoginCodeRequest;
import com.xforceplus.ant.system.client.model.MsUpdateAuthLoginStatusRequest;

import com.xforceplus.ant.system.client.model.sso.OpsSsoUrlGetRequest;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "sso", description = "the sso API")
public interface SsoApi {

    @ApiOperation(value = "账号登录", notes = "", response = MsResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/sso/accountLogin",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse accountLogin( @NotNull @ApiParam(value = "集团标识", required = true) @RequestParam(value = "token", required = true) String token, @NotNull @ApiParam(value = "跳转密码(解密串)", required = true) @RequestParam(value = "pwd", required = true) String pwd, @ApiParam(value = "重定向前端相对路径") @RequestParam(value = "redirect", required = false) String redirect);


    @ApiOperation(value = "账号登录测试URL", notes = "", response = MsResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsResponse.class) })
    @RequestMapping(value = "/sso/accountLoginTestUrl",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse accountLoginTestUrl( @NotNull @ApiParam(value = "登录账号", required = true) @RequestParam(value = "account", required = true) String account, @NotNull @ApiParam(value = "集团标识", required = true) @RequestParam(value = "token", required = true) String token, @NotNull @ApiParam(value = "加密公钥", required = true) @RequestParam(value = "publicKey", required = true) String publicKey, @NotNull @ApiParam(value = "重定向前端相对路径", required = true) @RequestParam(value = "redirect", required = true) String redirect);


    @ApiOperation(value = "添加单点登录 SecretKey", notes = "", response = MsResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/sso/addSecretKey",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse addSecretKey( @NotNull @ApiParam(value = "登录账号", required = true) @RequestParam(value = "account", required = true) String account, @NotNull @ApiParam(value = "SecretKey", required = true) @RequestParam(value = "secretKey", required = true) String secretKey, @ApiParam(value = "备注") @RequestParam(value = "remark", required = false) String remark);


    @ApiOperation(value = "申请变更供应商名称", notes = "", response = MsResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/sso/applyChangeCmpName",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse applyChangeCmpName(@ApiParam(value = "request" ,required=true ) @RequestBody MsSsoApplyChangeCmpNameRequest request);


    @ApiOperation(value = "获取用户TOKEN", notes = "", response = MsSsoResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsSsoResponse.class) })
    @RequestMapping(value = "/sso/getUserAccessToken",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsSsoResponse getUserAccessToken(@ApiParam(value = "request" ,required=true ) @RequestBody MsSsoGetUserAccessTokenRequest request);


    @ApiOperation(value = "获取用户ID", notes = "", response = MsSsoGetUserIdResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsSsoGetUserIdResponse.class) })
    @RequestMapping(value = "/sso/getUserId",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsSsoGetUserIdResponse getUserId(@ApiParam(value = "request" ,required=true ) @RequestBody MsSsoGetUserIdRequest request);


    @ApiOperation(value = "查询授权登录状态", notes = "", response = MsQueryAuthLoginResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsQueryAuthLoginResponse.class) })
    @RequestMapping(value = "/sso/queryAuthLogin",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsQueryAuthLoginResponse queryAuthLogin( @NotNull @ApiParam(value = "登录Id", required = true) @RequestParam(value = "loginId", required = true) String loginId);


    @ApiOperation(value = "手机验证码登录发送", notes = "", response = MsSsoSendSmsLoginCodeResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsSsoSendSmsLoginCodeResponse.class) })
    @RequestMapping(value = "/sso/sendSmsLoginCode",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsSsoSendSmsLoginCodeResponse sendSmsLoginCode(@ApiParam(value = "request" ,required=true ) @RequestBody MsSsoSendSmsLoginCodeRequest request);


    @ApiOperation(value = "设置授权登录", notes = "", response = MsResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/sso/setAuthLogin",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse setAuthLogin(@ApiParam(value = "request" ,required=true ) @RequestBody MsSetAuthLoginRequest request);


    @ApiOperation(value = "更新授权登录状态", notes = "", response = MsResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/sso/updateAuthLoginStatus",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse updateAuthLoginStatus(@ApiParam(value = "request" ,required=true ) @RequestBody MsUpdateAuthLoginStatusRequest request);


    @ApiOperation(value = "手机验证码登录验证", notes = "", response = MsResponse.class, tags={ "Sso", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/sso/validateSmsLoginCode",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse validateSmsLoginCode(@ApiParam(value = "request" ,required=true ) @RequestBody MsSsoValidateSmsLoginCodeRequest request);



    @ApiOperation(value = "获取用户TOKEN(运维专用)", response = MsSsoResponse.class, tags={ "Sso"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = MsSsoResponse.class) })
    @RequestMapping(value = "/sso/ops/getUserAccessToken",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsSsoResponse getUserAccessTokenByOps(@ApiParam(value = "request" ,required=true ) @RequestBody OpsSsoUrlGetRequest request);


}
