package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsResponse;
import com.xforceplus.ant.system.client.model.MsSupportModel;
import com.xforceplus.ant.system.client.model.MsSupportQueryModel;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "supportCenter", description = "the supportCenter API")
public interface SupportCenterApi {

    @ApiOperation(value = "新增帮助消息", notes = "", response = MsResponse.class, tags={ "SupportCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/supportCenter/add",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse add(@ApiParam(value = "帮助消息model" ,required=true ) @RequestBody MsSupportModel supportModel);


    @ApiOperation(value = "删除帮助消息", notes = "", response = MsResponse.class, tags={ "SupportCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/supportCenter/delete",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
     MsResponse delete( @NotNull @ApiParam(value = "消息ID", required = true) @RequestParam(value = "id", required = true) Long id);


    @ApiOperation(value = "启用或停用帮助消息", notes = "", response = MsResponse.class, tags={ "SupportCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/supportCenter/enableOrDisable",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse enableOrDisable( @NotNull @ApiParam(value = "消息ID", required = true) @RequestParam(value = "id", required = true) Long id, @NotNull @ApiParam(value = "操作类型 1-启用 0-停用", required = true) @RequestParam(value = "able", required = true) Integer able, @ApiParam(value = "操作用户id") @RequestParam(value = "opUserId", required = false) Long opUserId, @ApiParam(value = "操作用户名称") @RequestParam(value = "opUserName", required = false) String opUserName);


    @ApiOperation(value = "查询帮助消息 ID", notes = "", response = MsResponse.class, tags={ "SupportCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/supportCenter/info",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse info( @NotNull @ApiParam(value = "消息ID", required = true) @RequestParam(value = "id", required = true) Long id);


    @ApiOperation(value = "查询帮助消息列表", notes = "", response = MsResponse.class, tags={ "SupportCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/supportCenter/list",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse list(@ApiParam(value = "帮助消息查询model" ,required=true ) @RequestBody MsSupportQueryModel supportQueryModel);


    @ApiOperation(value = "更新帮助消息", notes = "", response = MsResponse.class, tags={ "SupportCenter", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsResponse.class) })
    @RequestMapping(value = "/supportCenter/modify",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse update(@ApiParam(value = "帮助消息model" ,required=true ) @RequestBody MsSupportModel supportModel);

}
