package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsTSADeviceInvoiceInfoResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "taxware-sa", description = "the taxware-sa API")
public interface TaxwareSaApi {

    @ApiOperation(value = "获取税盘基础信息", notes = "", response = MsTSADeviceInvoiceInfoResponse.class, tags={ "TaxWareSa", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsTSADeviceInvoiceInfoResponse.class) })
    @RequestMapping(value = "/taxware-sa/device-invoice-info/{taxNo}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsTSADeviceInvoiceInfoResponse getDeviceInvoiceInfo(@ApiParam(value = "税号",required=true ) @PathVariable("taxNo") String taxNo, @NotNull @ApiParam(value = "设备编号", required = true) @RequestParam(value = "deviceCode", required = true) String deviceCode, @NotNull @ApiParam(value = "机器编号", required = true) @RequestParam(value = "machineCode", required = true) String machineCode, @NotNull @ApiParam(value = "发票类型 c-普票 s-专票 ce-普电票 se-专电票", required = true) @RequestParam(value = "invoiceType", required = true) String invoiceType);

}
