package com.xforceplus.ant.system.client.api.kylin;


import com.xforceplus.ant.system.client.model.kylin.KylinResponse;
import com.xforceplus.phoenix.kylin.service.pojo.dto.bill.Bill;
import com.xforceplus.phoenix.kylin.service.pojo.dto.bill.BillItem;
import com.xforceplus.phoenix.kylin.service.pojo.dto.request.BatchIdRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 结算单特殊业务
 *
 * @Author xiezhongyong
 * @Date 2022/12/28
 */
@Api(value = "kylin-bill", description = "结算单特殊业务 接口服务", tags = {"kylin-bill"})
public interface KylinBillApi {


    @ApiOperation("新增单个结算单")
    @RequestMapping(value = "/bill", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<String> saveBill(@RequestBody @Valid Bill bill);


    @ApiOperation("删除单个结算单")
    @RequestMapping(value = "/bill", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<String> deleteBill(@RequestParam("id") String id);


    @ApiOperation("修改单个结算单")
    @RequestMapping(value = "/bill", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<String> updateBill(@RequestBody @Valid Bill bill);


    @ApiOperation("获取单个结算单")
    @RequestMapping(value = "/bill", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<Bill> getBill(@RequestParam("id") String id);


    @ApiOperation("修改多个结算单")
    @RequestMapping(value = "/bill/list", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<String> batchUpdateBill(@RequestBody @Valid List<Bill> billList);


    @ApiOperation("新增多个结算单")
    @RequestMapping(value = "/bill/list", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<String> batchSaveBill(@RequestBody @Valid List<Bill> billList);

    @ApiOperation("删除多个结算单")
    @RequestMapping(value = "/bill/list", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<String> batchDeleteBill(@RequestBody @Valid BatchIdRequest request);

    @ApiOperation("单个修改或新增结算单")
    @RequestMapping(value = "/bill/upsert", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<String> saveOrUpdateBill(@RequestBody @Valid Bill bill);

    @ApiOperation("批量修改或新增结算单")
    @RequestMapping(value = "/bill/upsert/list", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<String> batchSaveOrUpdateBill(@RequestBody @Valid List<Bill> billList);

    @ApiOperation("获取结算单列表")
    @RequestMapping(value = "/bill/list/query", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<List<Bill>> listBill(@RequestBody @Valid BatchIdRequest request);


    @ApiOperation("查询单个结算单明细")
    @RequestMapping(value = "/bill/item", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<BillItem> getBillItem(@RequestParam("id") String itemId);

    @ApiOperation("删除单个结算单明细")
    @RequestMapping(value = "/bill/item", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<String> deleteBillItem(@RequestParam("id") String itemId);

    @ApiOperation("修改单个结算单明细")
    @RequestMapping(value = "/bill/item", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<String> updateBillItem(@RequestBody @Valid BillItem billItem);


    @ApiOperation("新增单个结算单明细")
    @RequestMapping(value = "/bill/item", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<String> saveBillItem(@RequestBody @Valid BillItem billItem);

    @ApiOperation("新增或修改单个结算单明细")
    @RequestMapping(value = "/bill/item/upsert", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    KylinResponse<String> saveOrUpdateBillItem(@RequestBody @Valid BillItem billItem);


}
