package com.xforceplus.ant.system.client.enums;


/**
 * Describe: OperatorTypeV2Enum
 *
 * @Author xiezhongyong
 * @Date 2022/12/15
 */
public enum OperatorTypeV2Enum {

    GOOD_DISCOUNT_RATE("GOOD_DISCOUNT_RATE", "折扣率"),
    GOOD_CHECK_STATUS("GOOD_CHECK_STATUS", "需要审核的字段操作"),
    GOOD_UNIT_MODEL("GOOD_UNIT_MODEL", "单位模式"),
    GOODS_TAX_PRE_CONTEXT("GOODS_TAX_PRE_CONTEXT", "优惠政策内容");



    private String code;
    private String desc;

    /**
     * 方法描述 构造器
     */
    OperatorTypeV2Enum(String code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    /**
     * 方法描述 获取value
     */
    public String getCode() {
        return code;
    }

    /**
     * 方法描述 获取描述
     */
    public String getDescription() {
        return desc;
    }

    public static OperatorTypeV2Enum fromValue(String value) {

        for (OperatorTypeV2Enum e : values()) {
            if (e.getCode().equals(value)) {
                return e;
            }
        }
        return null;
    }
}
