package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsBacklogCountResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 统计待办事项查询返回结果
 */
@ApiModel(description = "统计待办事项查询返回结果")

@JsonInclude(NON_NULL)
public class MsBacklogCountResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("result")
  private List<MsBacklogCountResult> result = new ArrayList<MsBacklogCountResult>();

  @JsonIgnore
  public MsBacklogCountResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 处理状态 0-失败 1-成功 2-处理中
   * @return code
  **/
  @ApiModelProperty(value = "处理状态 0-失败 1-成功 2-处理中")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsBacklogCountResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @ApiModelProperty(value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsBacklogCountResponse total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * 总数
   * @return total
  **/
  @ApiModelProperty(value = "总数")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public MsBacklogCountResponse result(List<MsBacklogCountResult> result) {
    this.result = result;
    return this;
  }

  public MsBacklogCountResponse addResultItem(MsBacklogCountResult resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 数据
   * @return result
  **/
  @ApiModelProperty(value = "数据")
  public List<MsBacklogCountResult> getResult() {
    return result;
  }

  public void setResult(List<MsBacklogCountResult> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBacklogCountResponse backlogCountResponse = (MsBacklogCountResponse) o;
    return Objects.equals(this.code, backlogCountResponse.code) &&
        Objects.equals(this.message, backlogCountResponse.message) &&
        Objects.equals(this.total, backlogCountResponse.total) &&
        Objects.equals(this.result, backlogCountResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, total, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBacklogCountResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
