package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 结算单统计返回结果
 */
@ApiModel(description = "结算单统计返回结果")

@JsonInclude(NON_NULL)
public class MsBillStatisticResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("totalAmountWithTax")
  private String totalAmountWithTax = null;

  @JsonProperty("totalAlreadyAmountWithTax")
  private String totalAlreadyAmountWithTax = null;

  @JsonIgnore
  public MsBillStatisticResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 处理状态 0-失败 1-成功 2-处理中
   * @return code
  **/
  @ApiModelProperty(value = "处理状态 0-失败 1-成功 2-处理中")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsBillStatisticResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @ApiModelProperty(value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsBillStatisticResponse total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * 总数
   * @return total
  **/
  @ApiModelProperty(value = "总数")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public MsBillStatisticResponse totalAmountWithTax(String totalAmountWithTax) {
    this.totalAmountWithTax = totalAmountWithTax;
    return this;
  }

   /**
   * 价税合计总金额
   * @return totalAmountWithTax
  **/
  @ApiModelProperty(value = "价税合计总金额")
  public String getTotalAmountWithTax() {
    return totalAmountWithTax;
  }

  public void setTotalAmountWithTax(String totalAmountWithTax) {
    this.totalAmountWithTax = totalAmountWithTax;
  }

  @JsonIgnore
  public MsBillStatisticResponse totalAlreadyAmountWithTax(String totalAlreadyAmountWithTax) {
    this.totalAlreadyAmountWithTax = totalAlreadyAmountWithTax;
    return this;
  }

   /**
   * 已开价税合计总金额
   * @return totalAlreadyAmountWithTax
  **/
  @ApiModelProperty(value = "已开价税合计总金额")
  public String getTotalAlreadyAmountWithTax() {
    return totalAlreadyAmountWithTax;
  }

  public void setTotalAlreadyAmountWithTax(String totalAlreadyAmountWithTax) {
    this.totalAlreadyAmountWithTax = totalAlreadyAmountWithTax;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBillStatisticResponse billStatisticResponse = (MsBillStatisticResponse) o;
    return Objects.equals(this.code, billStatisticResponse.code) &&
        Objects.equals(this.message, billStatisticResponse.message) &&
        Objects.equals(this.total, billStatisticResponse.total) &&
        Objects.equals(this.totalAmountWithTax, billStatisticResponse.totalAmountWithTax) &&
        Objects.equals(this.totalAlreadyAmountWithTax, billStatisticResponse.totalAlreadyAmountWithTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, total, totalAmountWithTax, totalAlreadyAmountWithTax);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBillStatisticResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    totalAmountWithTax: ").append(toIndentedString(totalAmountWithTax)).append("\n");
    sb.append("    totalAlreadyAmountWithTax: ").append(toIndentedString(totalAlreadyAmountWithTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
