package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsCoopGoodsModel
 */

@JsonInclude(NON_NULL)
public class MsCoopGoodsModel {
  @JsonProperty("goodsId")
  private Long goodsId = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("goodsName")
  private String goodsName = null;

  @JsonProperty("goodsNo")
  private String goodsNo = null;

  @JsonProperty("specification")
  private String specification = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("unitPrice")
  private String unitPrice = null;

  @JsonProperty("priceMethod")
  private Integer priceMethod = null;

  @JsonProperty("taxName")
  private String taxName = null;

  @JsonProperty("taxCode")
  private String taxCode = null;

  @JsonProperty("taxShortName")
  private String taxShortName = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxPre")
  private String taxPre = null;

  @JsonProperty("taxPreCon")
  private String taxPreCon = null;

  @ApiModelProperty("即征即退类型")
  private String taxCollectionRefundDetail;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("goodsType")
  private Integer goodsType = null;

  @JsonProperty("cooperatorTenantId")
  private Long cooperatorTenantId = null;

  @JsonProperty("cooperatorTenantName")
  private String cooperatorTenantName = null;

  @JsonProperty("cooperatorTenantCode")
  private String cooperatorTenantCode = null;

  @JsonIgnore
  public MsCoopGoodsModel goodsId(Long goodsId) {
    this.goodsId = goodsId;
    return this;
  }

   /**
   * 自有商品主键
   * @return goodsId
  **/
  @ApiModelProperty(value = "自有商品主键")
  public Long getGoodsId() {
    return goodsId;
  }

  public void setGoodsId(Long goodsId) {
    this.goodsId = goodsId;
  }

  @JsonIgnore
  public MsCoopGoodsModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsCoopGoodsModel goodsName(String goodsName) {
    this.goodsName = goodsName;
    return this;
  }

   /**
   * 商品名称
   * @return goodsName
  **/
  @ApiModelProperty(value = "商品名称")
  public String getGoodsName() {
    return goodsName;
  }

  public void setGoodsName(String goodsName) {
    this.goodsName = goodsName;
  }

  @JsonIgnore
  public MsCoopGoodsModel goodsNo(String goodsNo) {
    this.goodsNo = goodsNo;
    return this;
  }

   /**
   * 商品编码
   * @return goodsNo
  **/
  @ApiModelProperty(value = "商品编码")
  public String getGoodsNo() {
    return goodsNo;
  }

  public void setGoodsNo(String goodsNo) {
    this.goodsNo = goodsNo;
  }

  @JsonIgnore
  public MsCoopGoodsModel specification(String specification) {
    this.specification = specification;
    return this;
  }

   /**
   * 规格型号
   * @return specification
  **/
  @ApiModelProperty(value = "规格型号")
  public String getSpecification() {
    return specification;
  }

  public void setSpecification(String specification) {
    this.specification = specification;
  }

  @JsonIgnore
  public MsCoopGoodsModel quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public MsCoopGoodsModel unitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 单价
   * @return unitPrice
  **/
  @ApiModelProperty(value = "单价")
  public String getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public MsCoopGoodsModel priceMethod(Integer priceMethod) {
    this.priceMethod = priceMethod;
    return this;
  }

   /**
   * 计价方式, 0 = 不含税，1=含税
   * @return priceMethod
  **/
  @ApiModelProperty(value = "计价方式, 0 = 不含税，1=含税")
  public Integer getPriceMethod() {
    return priceMethod;
  }

  public void setPriceMethod(Integer priceMethod) {
    this.priceMethod = priceMethod;
  }

  @JsonIgnore
  public MsCoopGoodsModel taxName(String taxName) {
    this.taxName = taxName;
    return this;
  }

   /**
   * 税编名称
   * @return taxName
  **/
  @ApiModelProperty(value = "税编名称")
  public String getTaxName() {
    return taxName;
  }

  public void setTaxName(String taxName) {
    this.taxName = taxName;
  }

  @JsonIgnore
  public MsCoopGoodsModel taxCode(String taxCode) {
    this.taxCode = taxCode;
    return this;
  }

   /**
   * 税收编码
   * @return taxCode
  **/
  @ApiModelProperty(value = "税收编码")
  public String getTaxCode() {
    return taxCode;
  }

  public void setTaxCode(String taxCode) {
    this.taxCode = taxCode;
  }

  @JsonIgnore
  public MsCoopGoodsModel taxShortName(String taxShortName) {
    this.taxShortName = taxShortName;
    return this;
  }

   /**
   * 税编简称
   * @return taxShortName
  **/
  @ApiModelProperty(value = "税编简称")
  public String getTaxShortName() {
    return taxShortName;
  }

  public void setTaxShortName(String taxShortName) {
    this.taxShortName = taxShortName;
  }

  @JsonIgnore
  public MsCoopGoodsModel taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public MsCoopGoodsModel taxPre(String taxPre) {
    this.taxPre = taxPre;
    return this;
  }

   /**
   * 是否享受优惠政策， 0 否， 1 是
   * @return taxPre
  **/
  @ApiModelProperty(value = "是否享受优惠政策， 0 否， 1 是")
  public String getTaxPre() {
    return taxPre;
  }

  public void setTaxPre(String taxPre) {
    this.taxPre = taxPre;
  }

  @JsonIgnore
  public MsCoopGoodsModel taxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
    return this;
  }

   /**
   * 优惠政策内容
   * @return taxPreCon
  **/
  @ApiModelProperty(value = "优惠政策内容")
  public String getTaxPreCon() {
    return taxPreCon;
  }

  public void setTaxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
  }

  public String getTaxCollectionRefundDetail() {
    return taxCollectionRefundDetail;
  }

  public void setTaxCollectionRefundDetail(String taxCollectionRefundDetail) {
    this.taxCollectionRefundDetail = taxCollectionRefundDetail;
  }

  @JsonIgnore
  public MsCoopGoodsModel zeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 零税率标识， 0 出口退税， 1 免税，2 不征税， 2 普通零税率
   * @return zeroTax
  **/
  @ApiModelProperty(value = "零税率标识， 0 出口退税， 1 免税，2 不征税， 2 普通零税率")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }

  @JsonIgnore
  public MsCoopGoodsModel companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsCoopGoodsModel companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsCoopGoodsModel goodsType(Integer goodsType) {
    this.goodsType = goodsType;
    return this;
  }

   /**
   * 系统商品类型, 0=协同购方，1=协同销方
   * @return goodsType
  **/
  @ApiModelProperty(value = "系统商品类型, 0=协同购方，1=协同销方")
  public Integer getGoodsType() {
    return goodsType;
  }

  public void setGoodsType(Integer goodsType) {
    this.goodsType = goodsType;
  }

  @JsonIgnore
  public MsCoopGoodsModel cooperatorTenantId(Long cooperatorTenantId) {
    this.cooperatorTenantId = cooperatorTenantId;
    return this;
  }

   /**
   * 协同方租户id
   * @return cooperatorTenantId
  **/
  @ApiModelProperty(value = "协同方租户id")
  public Long getCooperatorTenantId() {
    return cooperatorTenantId;
  }

  public void setCooperatorTenantId(Long cooperatorTenantId) {
    this.cooperatorTenantId = cooperatorTenantId;
  }

  @JsonIgnore
  public MsCoopGoodsModel cooperatorTenantName(String cooperatorTenantName) {
    this.cooperatorTenantName = cooperatorTenantName;
    return this;
  }

   /**
   * 协同方租户名称
   * @return cooperatorTenantName
  **/
  @ApiModelProperty(value = "协同方租户名称")
  public String getCooperatorTenantName() {
    return cooperatorTenantName;
  }

  public void setCooperatorTenantName(String cooperatorTenantName) {
    this.cooperatorTenantName = cooperatorTenantName;
  }

  @JsonIgnore
  public MsCoopGoodsModel cooperatorTenantCode(String cooperatorTenantCode) {
    this.cooperatorTenantCode = cooperatorTenantCode;
    return this;
  }

   /**
   * 协同方租户代码
   * @return cooperatorTenantCode
  **/
  @ApiModelProperty(value = "协同方租户代码")
  public String getCooperatorTenantCode() {
    return cooperatorTenantCode;
  }

  public void setCooperatorTenantCode(String cooperatorTenantCode) {
    this.cooperatorTenantCode = cooperatorTenantCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCoopGoodsModel coopGoodsModel = (MsCoopGoodsModel) o;
    return Objects.equals(this.goodsId, coopGoodsModel.goodsId) &&
        Objects.equals(this.id, coopGoodsModel.id) &&
        Objects.equals(this.goodsName, coopGoodsModel.goodsName) &&
        Objects.equals(this.goodsNo, coopGoodsModel.goodsNo) &&
        Objects.equals(this.specification, coopGoodsModel.specification) &&
        Objects.equals(this.quantityUnit, coopGoodsModel.quantityUnit) &&
        Objects.equals(this.unitPrice, coopGoodsModel.unitPrice) &&
        Objects.equals(this.priceMethod, coopGoodsModel.priceMethod) &&
        Objects.equals(this.taxName, coopGoodsModel.taxName) &&
        Objects.equals(this.taxCode, coopGoodsModel.taxCode) &&
        Objects.equals(this.taxShortName, coopGoodsModel.taxShortName) &&
        Objects.equals(this.taxRate, coopGoodsModel.taxRate) &&
        Objects.equals(this.taxPre, coopGoodsModel.taxPre) &&
        Objects.equals(this.taxPreCon, coopGoodsModel.taxPreCon) &&
        Objects.equals(this.zeroTax, coopGoodsModel.zeroTax) &&
        Objects.equals(this.companyName, coopGoodsModel.companyName) &&
        Objects.equals(this.companyTaxNo, coopGoodsModel.companyTaxNo) &&
        Objects.equals(this.goodsType, coopGoodsModel.goodsType) &&
        Objects.equals(this.cooperatorTenantId, coopGoodsModel.cooperatorTenantId) &&
        Objects.equals(this.cooperatorTenantName, coopGoodsModel.cooperatorTenantName) &&
        Objects.equals(this.cooperatorTenantCode, coopGoodsModel.cooperatorTenantCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsId, id, goodsName, goodsNo, specification, quantityUnit, unitPrice, priceMethod, taxName, taxCode, taxShortName, taxRate, taxPre, taxPreCon, zeroTax, companyName, companyTaxNo, goodsType, cooperatorTenantId, cooperatorTenantName, cooperatorTenantCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCoopGoodsModel {\n");
    
    sb.append("    goodsId: ").append(toIndentedString(goodsId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    goodsName: ").append(toIndentedString(goodsName)).append("\n");
    sb.append("    goodsNo: ").append(toIndentedString(goodsNo)).append("\n");
    sb.append("    specification: ").append(toIndentedString(specification)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    priceMethod: ").append(toIndentedString(priceMethod)).append("\n");
    sb.append("    taxName: ").append(toIndentedString(taxName)).append("\n");
    sb.append("    taxCode: ").append(toIndentedString(taxCode)).append("\n");
    sb.append("    taxShortName: ").append(toIndentedString(taxShortName)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxPre: ").append(toIndentedString(taxPre)).append("\n");
    sb.append("    taxPreCon: ").append(toIndentedString(taxPreCon)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    goodsType: ").append(toIndentedString(goodsType)).append("\n");
    sb.append("    cooperatorTenantId: ").append(toIndentedString(cooperatorTenantId)).append("\n");
    sb.append("    cooperatorTenantName: ").append(toIndentedString(cooperatorTenantName)).append("\n");
    sb.append("    cooperatorTenantCode: ").append(toIndentedString(cooperatorTenantCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
