package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 保利供应商审核材料对象
 */
@ApiModel(description = "保利供应商审核材料对象")

@JsonInclude(NON_NULL)
public class MsCrmAuditFileUrlBean {
  @JsonProperty("trc")
  private String trc = null;

  @JsonProperty("aoc")
  private String aoc = null;

  @JsonProperty("bcc")
  private String bcc = null;

  @JsonProperty("tcc")
  private String tcc = null;

  @JsonIgnore
  public MsCrmAuditFileUrlBean trc(String trc) {
    this.trc = trc;
    return this;
  }

   /**
   * trc
   * @return trc
  **/
  @ApiModelProperty(value = "trc")
  public String getTrc() {
    return trc;
  }

  public void setTrc(String trc) {
    this.trc = trc;
  }

  @JsonIgnore
  public MsCrmAuditFileUrlBean aoc(String aoc) {
    this.aoc = aoc;
    return this;
  }

   /**
   * aoc
   * @return aoc
  **/
  @ApiModelProperty(value = "aoc")
  public String getAoc() {
    return aoc;
  }

  public void setAoc(String aoc) {
    this.aoc = aoc;
  }

  @JsonIgnore
  public MsCrmAuditFileUrlBean bcc(String bcc) {
    this.bcc = bcc;
    return this;
  }

   /**
   * bcc
   * @return bcc
  **/
  @ApiModelProperty(value = "bcc")
  public String getBcc() {
    return bcc;
  }

  public void setBcc(String bcc) {
    this.bcc = bcc;
  }

  @JsonIgnore
  public MsCrmAuditFileUrlBean tcc(String tcc) {
    this.tcc = tcc;
    return this;
  }

   /**
   * tcc
   * @return tcc
  **/
  @ApiModelProperty(value = "tcc")
  public String getTcc() {
    return tcc;
  }

  public void setTcc(String tcc) {
    this.tcc = tcc;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCrmAuditFileUrlBean crmAuditFileUrlBean = (MsCrmAuditFileUrlBean) o;
    return Objects.equals(this.trc, crmAuditFileUrlBean.trc) &&
        Objects.equals(this.aoc, crmAuditFileUrlBean.aoc) &&
        Objects.equals(this.bcc, crmAuditFileUrlBean.bcc) &&
        Objects.equals(this.tcc, crmAuditFileUrlBean.tcc);
  }

  @Override
  public int hashCode() {
    return Objects.hash(trc, aoc, bcc, tcc);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCrmAuditFileUrlBean {\n");
    
    sb.append("    trc: ").append(toIndentedString(trc)).append("\n");
    sb.append("    aoc: ").append(toIndentedString(aoc)).append("\n");
    sb.append("    bcc: ").append(toIndentedString(bcc)).append("\n");
    sb.append("    tcc: ").append(toIndentedString(tcc)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
