package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsCrmContactQueryRequest
 */

@JsonInclude(NON_NULL)
public class MsCrmContactQueryRequest {
  @JsonProperty("pageNo")
  private Integer pageNo = 1;

  @JsonProperty("pageSize")
  private Integer pageSize = 10;

  @JsonProperty("coopUserId")
  private String coopUserId = null;

  @JsonIgnore
  public MsCrmContactQueryRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 当前页数
   * @return pageNo
  **/
  @ApiModelProperty(value = "当前页数")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsCrmContactQueryRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsCrmContactQueryRequest coopUserId(String coopUserId) {
    this.coopUserId = coopUserId;
    return this;
  }

   /**
   * 协同userId
   * @return coopUserId
  **/
  @ApiModelProperty(value = "协同userId")
  public String getCoopUserId() {
    return coopUserId;
  }

  public void setCoopUserId(String coopUserId) {
    this.coopUserId = coopUserId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCrmContactQueryRequest crmContactQueryRequest = (MsCrmContactQueryRequest) o;
    return Objects.equals(this.pageNo, crmContactQueryRequest.pageNo) &&
        Objects.equals(this.pageSize, crmContactQueryRequest.pageSize) &&
        Objects.equals(this.coopUserId, crmContactQueryRequest.coopUserId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageNo, pageSize, coopUserId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCrmContactQueryRequest {\n");
    
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    coopUserId: ").append(toIndentedString(coopUserId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
