package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 保存联系人信息请求
 */
@ApiModel(description = "保存联系人信息请求")

@JsonInclude(NON_NULL)
public class MsCrmSaveContactRequest {
  @JsonProperty("contactsId")
  private Integer contactsId = null;

  @JsonProperty("customerName")
  private String customerName = null;

  @JsonProperty("mobile")
  private String mobile = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("post")
  private String post = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("coopUserId")
  private String coopUserId = null;

  @JsonIgnore
  public MsCrmSaveContactRequest contactsId(Integer contactsId) {
    this.contactsId = contactsId;
    return this;
  }

   /**
   * 联系人ID
   * @return contactsId
  **/
  @ApiModelProperty(value = "联系人ID")
  public Integer getContactsId() {
    return contactsId;
  }

  public void setContactsId(Integer contactsId) {
    this.contactsId = contactsId;
  }

  @JsonIgnore
  public MsCrmSaveContactRequest customerName(String customerName) {
    this.customerName = customerName;
    return this;
  }

   /**
   * 客户名称
   * @return customerName
  **/
  @ApiModelProperty(value = "客户名称")
  public String getCustomerName() {
    return customerName;
  }

  public void setCustomerName(String customerName) {
    this.customerName = customerName;
  }

  @JsonIgnore
  public MsCrmSaveContactRequest mobile(String mobile) {
    this.mobile = mobile;
    return this;
  }

   /**
   * 手机号码
   * @return mobile
  **/
  @ApiModelProperty(value = "手机号码")
  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  @JsonIgnore
  public MsCrmSaveContactRequest companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsCrmSaveContactRequest companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsCrmSaveContactRequest email(String email) {
    this.email = email;
    return this;
  }

   /**
   * e-mail
   * @return email
  **/
  @ApiModelProperty(value = "e-mail")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @JsonIgnore
  public MsCrmSaveContactRequest post(String post) {
    this.post = post;
    return this;
  }

   /**
   * 职位
   * @return post
  **/
  @ApiModelProperty(value = "职位")
  public String getPost() {
    return post;
  }

  public void setPost(String post) {
    this.post = post;
  }

  @JsonIgnore
  public MsCrmSaveContactRequest remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public MsCrmSaveContactRequest coopUserId(String coopUserId) {
    this.coopUserId = coopUserId;
    return this;
  }

   /**
   * 协同用户ID
   * @return coopUserId
  **/
  @ApiModelProperty(value = "协同用户ID")
  public String getCoopUserId() {
    return coopUserId;
  }

  public void setCoopUserId(String coopUserId) {
    this.coopUserId = coopUserId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCrmSaveContactRequest crmSaveContactRequest = (MsCrmSaveContactRequest) o;
    return Objects.equals(this.contactsId, crmSaveContactRequest.contactsId) &&
        Objects.equals(this.customerName, crmSaveContactRequest.customerName) &&
        Objects.equals(this.mobile, crmSaveContactRequest.mobile) &&
        Objects.equals(this.companyTaxNo, crmSaveContactRequest.companyTaxNo) &&
        Objects.equals(this.companyName, crmSaveContactRequest.companyName) &&
        Objects.equals(this.email, crmSaveContactRequest.email) &&
        Objects.equals(this.post, crmSaveContactRequest.post) &&
        Objects.equals(this.remark, crmSaveContactRequest.remark) &&
        Objects.equals(this.coopUserId, crmSaveContactRequest.coopUserId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contactsId, customerName, mobile, companyTaxNo, companyName, email, post, remark, coopUserId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCrmSaveContactRequest {\n");
    
    sb.append("    contactsId: ").append(toIndentedString(contactsId)).append("\n");
    sb.append("    customerName: ").append(toIndentedString(customerName)).append("\n");
    sb.append("    mobile: ").append(toIndentedString(mobile)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    post: ").append(toIndentedString(post)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    coopUserId: ").append(toIndentedString(coopUserId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
