package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsCoopGoodsModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsGoodsModel
 */

@JsonInclude(NON_NULL)
public class MsGoodsModel {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("goodsName")
  private String goodsName = null;

  @JsonProperty("goodsNo")
  private String goodsNo = null;

  @JsonProperty("specification")
  private String specification = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("unitPrice")
  private String unitPrice = null;

  @JsonProperty("priceMethod")
  private Integer priceMethod = null;

  @JsonProperty("taxName")
  private String taxName = null;

  @JsonProperty("taxCode")
  private String taxCode = null;

  @JsonProperty("taxShortName")
  private String taxShortName = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxPre")
  private String taxPre = null;

  @JsonProperty("taxCollectionRefundDetail")
  private String taxCollectionRefundDetail = null;

  @JsonProperty("taxPreCon")
  private String taxPreCon = null;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("taxId")
  private Long taxId = null;

  @JsonProperty("goodsType")
  private Integer goodsType = null;

  @JsonProperty("mapGoods")
  private List<MsCoopGoodsModel> mapGoods = new ArrayList<MsCoopGoodsModel>();

  @JsonProperty("categoryId")
  private Long categoryId = null;

  @JsonProperty("categoryName")
  private String categoryName = null;

  @JsonProperty("categoryDiscountRate")
  private String categoryDiscountRate = null;

  @JsonProperty("goodsDiscountRate")
  private String goodsDiscountRate = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("unitModel")
  private String unitModel = null;

  @JsonProperty("newGoodName")
  private String newGoodName = null;

  @JsonProperty("newTaxCode")
  private String newTaxCode = null;

  @JsonProperty("type")
  private Integer type = null;

  @JsonProperty("discountRateUpdate")
  private Boolean discountRateUpdate = null;

  @JsonProperty("adverseGoods")
  private List<MsCoopGoodsModel> adverseGoods = new ArrayList<MsCoopGoodsModel>();

  @JsonIgnore
  public MsGoodsModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsGoodsModel goodsName(String goodsName) {
    this.goodsName = goodsName;
    return this;
  }

   /**
   * 商品名称
   * @return goodsName
  **/
  @ApiModelProperty(value = "商品名称")
  public String getGoodsName() {
    return goodsName;
  }

  public void setGoodsName(String goodsName) {
    this.goodsName = goodsName;
  }

  @JsonIgnore
  public MsGoodsModel goodsNo(String goodsNo) {
    this.goodsNo = goodsNo;
    return this;
  }

   /**
   * 商品编码
   * @return goodsNo
  **/
  @ApiModelProperty(value = "商品编码")
  public String getGoodsNo() {
    return goodsNo;
  }

  public void setGoodsNo(String goodsNo) {
    this.goodsNo = goodsNo;
  }

  @JsonIgnore
  public MsGoodsModel specification(String specification) {
    this.specification = specification;
    return this;
  }

   /**
   * 规格型号
   * @return specification
  **/
  @ApiModelProperty(value = "规格型号")
  public String getSpecification() {
    return specification;
  }

  public void setSpecification(String specification) {
    this.specification = specification;
  }

  @JsonIgnore
  public MsGoodsModel quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public MsGoodsModel unitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 单价
   * @return unitPrice
  **/
  @ApiModelProperty(value = "单价")
  public String getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public MsGoodsModel priceMethod(Integer priceMethod) {
    this.priceMethod = priceMethod;
    return this;
  }

   /**
   * 计价方式, 0 = 不含税，1=含税
   * @return priceMethod
  **/
  @ApiModelProperty(value = "计价方式, 0 = 不含税，1=含税")
  public Integer getPriceMethod() {
    return priceMethod;
  }

  public void setPriceMethod(Integer priceMethod) {
    this.priceMethod = priceMethod;
  }

  @JsonIgnore
  public MsGoodsModel taxName(String taxName) {
    this.taxName = taxName;
    return this;
  }

   /**
   * 税编名称
   * @return taxName
  **/
  @ApiModelProperty(value = "税编名称")
  public String getTaxName() {
    return taxName;
  }

  public void setTaxName(String taxName) {
    this.taxName = taxName;
  }

  @JsonIgnore
  public MsGoodsModel taxCode(String taxCode) {
    this.taxCode = taxCode;
    return this;
  }

   /**
   * 税收编码
   * @return taxCode
  **/
  @ApiModelProperty(value = "税收编码")
  public String getTaxCode() {
    return taxCode;
  }

  public void setTaxCode(String taxCode) {
    this.taxCode = taxCode;
  }

  @JsonIgnore
  public MsGoodsModel taxShortName(String taxShortName) {
    this.taxShortName = taxShortName;
    return this;
  }

   /**
   * 税编简称
   * @return taxShortName
  **/
  @ApiModelProperty(value = "税编简称")
  public String getTaxShortName() {
    return taxShortName;
  }

  public void setTaxShortName(String taxShortName) {
    this.taxShortName = taxShortName;
  }

  @JsonIgnore
  public MsGoodsModel taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public MsGoodsModel taxPre(String taxPre) {
    this.taxPre = taxPre;
    return this;
  }

   /**
   * 是否享受优惠政策， 0 否， 1 是
   * @return taxPre
  **/
  @ApiModelProperty(value = "是否享受优惠政策， 0 否， 1 是")
  public String getTaxPre() {
    return taxPre;
  }

  public void setTaxPre(String taxPre) {
    this.taxPre = taxPre;
  }

  @JsonIgnore
  public MsGoodsModel taxCollectionRefundDetail(String taxCollectionRefundDetail) {
    this.taxCollectionRefundDetail = taxCollectionRefundDetail;
    return this;
  }

  /**
   * 即征即退类型
   * @return taxPreCon
   **/
  @ApiModelProperty(value = "即征即退类型")
  public String getTaxCollectionRefundDetail() {
    return taxCollectionRefundDetail;
  }

  public void setTaxCollectionRefundDetail(String taxCollectionRefundDetail) {
    this.taxCollectionRefundDetail = taxCollectionRefundDetail;
  }

  @JsonIgnore
  public MsGoodsModel taxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
    return this;
  }


  /**
   * 优惠政策内容
   * @return taxCollectionRefundDetail
   **/
  @ApiModelProperty(value = "优惠政策内容")
  public String getTaxPreCon() {
    return taxPreCon;
  }

  public void setTaxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
  }

  @JsonIgnore
  public MsGoodsModel zeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 零税率标识， 0 出口退税， 1 免税，2 不征税， 2 普通零税率
   * @return zeroTax
  **/
  @ApiModelProperty(value = "零税率标识， 0 出口退税， 1 免税，2 不征税， 2 普通零税率")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }

  @JsonIgnore
  public MsGoodsModel companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsGoodsModel companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsGoodsModel companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsGoodsModel tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGoodsModel taxId(Long taxId) {
    this.taxId = taxId;
    return this;
  }

   /**
   * 税编Id
   * @return taxId
  **/
  @ApiModelProperty(value = "税编Id")
  public Long getTaxId() {
    return taxId;
  }

  public void setTaxId(Long taxId) {
    this.taxId = taxId;
  }

  @JsonIgnore
  public MsGoodsModel goodsType(Integer goodsType) {
    this.goodsType = goodsType;
    return this;
  }

   /**
   * 系统商品类型, 0=协同购方，1=协同销方
   * @return goodsType
  **/
  @ApiModelProperty(value = "系统商品类型, 0=协同购方，1=协同销方")
  public Integer getGoodsType() {
    return goodsType;
  }

  public void setGoodsType(Integer goodsType) {
    this.goodsType = goodsType;
  }

  @JsonIgnore
  public MsGoodsModel mapGoods(List<MsCoopGoodsModel> mapGoods) {
    this.mapGoods = mapGoods;
    return this;
  }

  public MsGoodsModel addMapGoodsItem(MsCoopGoodsModel mapGoodsItem) {
    this.mapGoods.add(mapGoodsItem);
    return this;
  }

   /**
   * 协同商品数组
   * @return mapGoods
  **/
  @ApiModelProperty(value = "协同商品数组")
  public List<MsCoopGoodsModel> getMapGoods() {
    return mapGoods;
  }

  public void setMapGoods(List<MsCoopGoodsModel> mapGoods) {
    this.mapGoods = mapGoods;
  }

  @JsonIgnore
  public MsGoodsModel categoryId(Long categoryId) {
    this.categoryId = categoryId;
    return this;
  }

   /**
   * 品类id
   * @return categoryId
  **/
  @ApiModelProperty(value = "品类id")
  public Long getCategoryId() {
    return categoryId;
  }

  public void setCategoryId(Long categoryId) {
    this.categoryId = categoryId;
  }

  @JsonIgnore
  public MsGoodsModel categoryName(String categoryName) {
    this.categoryName = categoryName;
    return this;
  }

   /**
   * 品类名称
   * @return categoryName
  **/
  @ApiModelProperty(value = "品类名称")
  public String getCategoryName() {
    return categoryName;
  }

  public void setCategoryName(String categoryName) {
    this.categoryName = categoryName;
  }

  @JsonIgnore
  public MsGoodsModel categoryDiscountRate(String categoryDiscountRate) {
    this.categoryDiscountRate = categoryDiscountRate;
    return this;
  }

   /**
   * 品牌的最大折扣率
   * @return categoryDiscountRate
  **/
  @ApiModelProperty(value = "品牌的最大折扣率")
  public String getCategoryDiscountRate() {
    return categoryDiscountRate;
  }

  public void setCategoryDiscountRate(String categoryDiscountRate) {
    this.categoryDiscountRate = categoryDiscountRate;
  }

  @JsonIgnore
  public MsGoodsModel goodsDiscountRate(String goodsDiscountRate) {
    this.goodsDiscountRate = goodsDiscountRate;
    return this;
  }

   /**
   * 商品的最大折扣率
   * @return goodsDiscountRate
  **/
  @ApiModelProperty(value = "商品的最大折扣率")
  public String getGoodsDiscountRate() {
    return goodsDiscountRate;
  }

  public void setGoodsDiscountRate(String goodsDiscountRate) {
    this.goodsDiscountRate = goodsDiscountRate;
  }

  @JsonIgnore
  public MsGoodsModel status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 商品初始化状态，默认： 0 = 初始化， 1= 待审核， 2= 驳回，3=已审核
   * @return status
  **/
  @ApiModelProperty(value = "商品初始化状态，默认： 0 = 初始化， 1= 待审核， 2= 驳回，3=已审核")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public MsGoodsModel unitModel(String unitModel) {
    this.unitModel = unitModel;
    return this;
  }

   /**
   * 商品的单位模式，默认为数量模式 0= 数量模式， 1 = 件箱模式
   * @return unitModel
  **/
  @ApiModelProperty(value = "商品的单位模式，默认为数量模式 0= 数量模式， 1 = 件箱模式")
  public String getUnitModel() {
    return unitModel;
  }

  public void setUnitModel(String unitModel) {
    this.unitModel = unitModel;
  }

  @JsonIgnore
  public MsGoodsModel newGoodName(String newGoodName) {
    this.newGoodName = newGoodName;
    return this;
  }

   /**
   * Get newGoodName
   * @return newGoodName
  **/
  @ApiModelProperty(value = "")
  public String getNewGoodName() {
    return newGoodName;
  }

  public void setNewGoodName(String newGoodName) {
    this.newGoodName = newGoodName;
  }

  @JsonIgnore
  public MsGoodsModel newTaxCode(String newTaxCode) {
    this.newTaxCode = newTaxCode;
    return this;
  }

   /**
   * Get newTaxCode
   * @return newTaxCode
  **/
  @ApiModelProperty(value = "")
  public String getNewTaxCode() {
    return newTaxCode;
  }

  public void setNewTaxCode(String newTaxCode) {
    this.newTaxCode = newTaxCode;
  }

  @JsonIgnore
  public MsGoodsModel type(Integer type) {
    this.type = type;
    return this;
  }

   /**
   * 系统商品类型, 0=协同购方，1=协同销方
   * @return type
  **/
  @ApiModelProperty(value = "系统商品类型, 0=协同购方，1=协同销方")
  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  @JsonIgnore
  public MsGoodsModel discountRateUpdate(Boolean discountRateUpdate) {
    this.discountRateUpdate = discountRateUpdate;
    return this;
  }

   /**
   * 折扣税率是否修改
   * @return discountRateUpdate
  **/
  @ApiModelProperty(value = "折扣税率是否修改")
  public Boolean getDiscountRateUpdate() {
    return discountRateUpdate;
  }

  public void setDiscountRateUpdate(Boolean discountRateUpdate) {
    this.discountRateUpdate = discountRateUpdate;
  }

  @JsonIgnore
  public MsGoodsModel adverseGoods(List<MsCoopGoodsModel> adverseGoods) {
    this.adverseGoods = adverseGoods;
    return this;
  }

  public MsGoodsModel addAdverseGoodsItem(MsCoopGoodsModel adverseGoodsItem) {
    this.adverseGoods.add(adverseGoodsItem);
    return this;
  }

   /**
   * 协同商品数组
   * @return adverseGoods
  **/
  @ApiModelProperty(value = "协同商品数组")
  public List<MsCoopGoodsModel> getAdverseGoods() {
    return adverseGoods;
  }

  public void setAdverseGoods(List<MsCoopGoodsModel> adverseGoods) {
    this.adverseGoods = adverseGoods;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsModel goodsModel = (MsGoodsModel) o;
    return Objects.equals(this.id, goodsModel.id) &&
        Objects.equals(this.goodsName, goodsModel.goodsName) &&
        Objects.equals(this.goodsNo, goodsModel.goodsNo) &&
        Objects.equals(this.specification, goodsModel.specification) &&
        Objects.equals(this.quantityUnit, goodsModel.quantityUnit) &&
        Objects.equals(this.unitPrice, goodsModel.unitPrice) &&
        Objects.equals(this.priceMethod, goodsModel.priceMethod) &&
        Objects.equals(this.taxName, goodsModel.taxName) &&
        Objects.equals(this.taxCode, goodsModel.taxCode) &&
        Objects.equals(this.taxShortName, goodsModel.taxShortName) &&
        Objects.equals(this.taxRate, goodsModel.taxRate) &&
        Objects.equals(this.taxPre, goodsModel.taxPre) &&
        Objects.equals(this.taxCollectionRefundDetail, goodsModel.taxCollectionRefundDetail) &&
        Objects.equals(this.taxPreCon, goodsModel.taxPreCon) &&
        Objects.equals(this.zeroTax, goodsModel.zeroTax) &&
        Objects.equals(this.companyName, goodsModel.companyName) &&
        Objects.equals(this.companyTaxNo, goodsModel.companyTaxNo) &&
        Objects.equals(this.companyId, goodsModel.companyId) &&
        Objects.equals(this.tenantId, goodsModel.tenantId) &&
        Objects.equals(this.taxId, goodsModel.taxId) &&
        Objects.equals(this.goodsType, goodsModel.goodsType) &&
        Objects.equals(this.mapGoods, goodsModel.mapGoods) &&
        Objects.equals(this.categoryId, goodsModel.categoryId) &&
        Objects.equals(this.categoryName, goodsModel.categoryName) &&
        Objects.equals(this.categoryDiscountRate, goodsModel.categoryDiscountRate) &&
        Objects.equals(this.goodsDiscountRate, goodsModel.goodsDiscountRate) &&
        Objects.equals(this.status, goodsModel.status) &&
        Objects.equals(this.unitModel, goodsModel.unitModel) &&
        Objects.equals(this.newGoodName, goodsModel.newGoodName) &&
        Objects.equals(this.newTaxCode, goodsModel.newTaxCode) &&
        Objects.equals(this.type, goodsModel.type) &&
        Objects.equals(this.discountRateUpdate, goodsModel.discountRateUpdate) &&
        Objects.equals(this.adverseGoods, goodsModel.adverseGoods);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, goodsName, goodsNo, specification, quantityUnit, unitPrice, priceMethod, taxName, taxCode, taxShortName, taxRate, taxPre, taxCollectionRefundDetail, taxPreCon, zeroTax, companyName, companyTaxNo, companyId, tenantId, taxId, goodsType, mapGoods, categoryId, categoryName, categoryDiscountRate, goodsDiscountRate, status, unitModel, newGoodName, newTaxCode, type, discountRateUpdate, adverseGoods);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsModel {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    goodsName: ").append(toIndentedString(goodsName)).append("\n");
    sb.append("    goodsNo: ").append(toIndentedString(goodsNo)).append("\n");
    sb.append("    specification: ").append(toIndentedString(specification)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    priceMethod: ").append(toIndentedString(priceMethod)).append("\n");
    sb.append("    taxName: ").append(toIndentedString(taxName)).append("\n");
    sb.append("    taxCode: ").append(toIndentedString(taxCode)).append("\n");
    sb.append("    taxShortName: ").append(toIndentedString(taxShortName)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxPre: ").append(toIndentedString(taxPre)).append("\n");
    sb.append("    taxCollectionRefundDetail: ").append(toIndentedString(taxCollectionRefundDetail)).append("\n");
    sb.append("    taxPreCon: ").append(toIndentedString(taxPreCon)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    taxId: ").append(toIndentedString(taxId)).append("\n");
    sb.append("    goodsType: ").append(toIndentedString(goodsType)).append("\n");
    sb.append("    mapGoods: ").append(toIndentedString(mapGoods)).append("\n");
    sb.append("    categoryId: ").append(toIndentedString(categoryId)).append("\n");
    sb.append("    categoryName: ").append(toIndentedString(categoryName)).append("\n");
    sb.append("    categoryDiscountRate: ").append(toIndentedString(categoryDiscountRate)).append("\n");
    sb.append("    goodsDiscountRate: ").append(toIndentedString(goodsDiscountRate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    unitModel: ").append(toIndentedString(unitModel)).append("\n");
    sb.append("    newGoodName: ").append(toIndentedString(newGoodName)).append("\n");
    sb.append("    newTaxCode: ").append(toIndentedString(newTaxCode)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    discountRateUpdate: ").append(toIndentedString(discountRateUpdate)).append("\n");
    sb.append("    adverseGoods: ").append(toIndentedString(adverseGoods)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
