package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 用户首页版本
 */
@ApiModel(description = "用户首页版本")

@JsonInclude(NON_NULL)
public class MsHomepageVerModel {
  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("userName")
  private String userName = null;

  @JsonProperty("version")
  private Integer version = null;

  @JsonIgnore
  public MsHomepageVerModel tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsHomepageVerModel userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsHomepageVerModel userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * 用户名称
   * @return userName
  **/
  @ApiModelProperty(value = "用户名称")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  @JsonIgnore
  public MsHomepageVerModel version(Integer version) {
    this.version = version;
    return this;
  }

   /**
   * 首页版本 0-旧 1-新
   * @return version
  **/
  @ApiModelProperty(value = "首页版本 0-旧 1-新")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsHomepageVerModel homepageVerModel = (MsHomepageVerModel) o;
    return Objects.equals(this.tenantId, homepageVerModel.tenantId) &&
        Objects.equals(this.userId, homepageVerModel.userId) &&
        Objects.equals(this.userName, homepageVerModel.userName) &&
        Objects.equals(this.version, homepageVerModel.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, userId, userName, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsHomepageVerModel {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
