package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsInstructionStepsModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 操作指引model
 */
@ApiModel(description = "操作指引model")

@JsonInclude(NON_NULL)
public class MsInstructionModel {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("typeCode")
  private String typeCode = null;

  @JsonProperty("userGroup")
  private Integer userGroup = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("groupName")
  private String groupName = null;

  @JsonProperty("title")
  private String title = null;

  @JsonProperty("content")
  private String content = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("steps")
  private List<MsInstructionStepsModel> steps = new ArrayList<MsInstructionStepsModel>();

  @JsonIgnore
  public MsInstructionModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * modelId
   * @return id
  **/
  @ApiModelProperty(value = "modelId")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsInstructionModel typeCode(String typeCode) {
    this.typeCode = typeCode;
    return this;
  }

   /**
   * 类型
   * @return typeCode
  **/
  @ApiModelProperty(value = "类型")
  public String getTypeCode() {
    return typeCode;
  }

  public void setTypeCode(String typeCode) {
    this.typeCode = typeCode;
  }

  @JsonIgnore
  public MsInstructionModel userGroup(Integer userGroup) {
    this.userGroup = userGroup;
    return this;
  }

   /**
   * 作用范围 1-特定购方 2-所有用户
   * @return userGroup
  **/
  @ApiModelProperty(value = "作用范围 1-特定购方 2-所有用户")
  public Integer getUserGroup() {
    return userGroup;
  }

  public void setUserGroup(Integer userGroup) {
    this.userGroup = userGroup;
  }

  @JsonIgnore
  public MsInstructionModel groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 购方租户id
   * @return groupId
  **/
  @ApiModelProperty(value = "购方租户id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsInstructionModel groupName(String groupName) {
    this.groupName = groupName;
    return this;
  }

   /**
   * 购方租户名称
   * @return groupName
  **/
  @ApiModelProperty(value = "购方租户名称")
  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  @JsonIgnore
  public MsInstructionModel title(String title) {
    this.title = title;
    return this;
  }

   /**
   * 主题
   * @return title
  **/
  @ApiModelProperty(value = "主题")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  @JsonIgnore
  public MsInstructionModel content(String content) {
    this.content = content;
    return this;
  }

   /**
   * 正文
   * @return content
  **/
  @ApiModelProperty(value = "正文")
  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  @JsonIgnore
  public MsInstructionModel status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态 0-停用 1-启用
   * @return status
  **/
  @ApiModelProperty(value = "状态 0-停用 1-启用")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsInstructionModel opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作用户id
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作用户id")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsInstructionModel opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作用户名称
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作用户名称")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsInstructionModel createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsInstructionModel createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建用户名称
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建用户名称")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsInstructionModel steps(List<MsInstructionStepsModel> steps) {
    this.steps = steps;
    return this;
  }

  public MsInstructionModel addStepsItem(MsInstructionStepsModel stepsItem) {
    this.steps.add(stepsItem);
    return this;
  }

   /**
   * Get steps
   * @return steps
  **/
  @ApiModelProperty(value = "")
  public List<MsInstructionStepsModel> getSteps() {
    return steps;
  }

  public void setSteps(List<MsInstructionStepsModel> steps) {
    this.steps = steps;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInstructionModel instructionModel = (MsInstructionModel) o;
    return Objects.equals(this.id, instructionModel.id) &&
        Objects.equals(this.typeCode, instructionModel.typeCode) &&
        Objects.equals(this.userGroup, instructionModel.userGroup) &&
        Objects.equals(this.groupId, instructionModel.groupId) &&
        Objects.equals(this.groupName, instructionModel.groupName) &&
        Objects.equals(this.title, instructionModel.title) &&
        Objects.equals(this.content, instructionModel.content) &&
        Objects.equals(this.status, instructionModel.status) &&
        Objects.equals(this.opUserId, instructionModel.opUserId) &&
        Objects.equals(this.opUserName, instructionModel.opUserName) &&
        Objects.equals(this.createTime, instructionModel.createTime) &&
        Objects.equals(this.createUserName, instructionModel.createUserName) &&
        Objects.equals(this.steps, instructionModel.steps);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, typeCode, userGroup, groupId, groupName, title, content, status, opUserId, opUserName, createTime, createUserName, steps);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInstructionModel {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    typeCode: ").append(toIndentedString(typeCode)).append("\n");
    sb.append("    userGroup: ").append(toIndentedString(userGroup)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    steps: ").append(toIndentedString(steps)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
