package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 操作指引步骤model
 */
@ApiModel(description = "操作指引步骤model")

@JsonInclude(NON_NULL)
public class MsInstructionStepsModel {
  @JsonProperty("url")
  private String url = null;

  @JsonProperty("description")
  private String description = null;

  @JsonIgnore
  public MsInstructionStepsModel url(String url) {
    this.url = url;
    return this;
  }

   /**
   * 图片地址
   * @return url
  **/
  @ApiModelProperty(value = "图片地址")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  @JsonIgnore
  public MsInstructionStepsModel description(String description) {
    this.description = description;
    return this;
  }

   /**
   * 描述
   * @return description
  **/
  @ApiModelProperty(value = "描述")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInstructionStepsModel instructionStepsModel = (MsInstructionStepsModel) o;
    return Objects.equals(this.url, instructionStepsModel.url) &&
        Objects.equals(this.description, instructionStepsModel.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, description);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInstructionStepsModel {\n");
    
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
