package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 菜单查询model
 */
@ApiModel(description = "菜单查询model")

@JsonInclude(NON_NULL)
public class MsMenuQueryModel {
  @JsonProperty("pid")
  private Long pid = null;

  @JsonProperty("productionLine")
  private String productionLine = null;

  @JsonIgnore
  public MsMenuQueryModel pid(Long pid) {
    this.pid = pid;
    return this;
  }

   /**
   * 父id
   * @return pid
  **/
  @ApiModelProperty(value = "父id")
  public Long getPid() {
    return pid;
  }

  public void setPid(Long pid) {
    this.pid = pid;
  }

  @JsonIgnore
  public MsMenuQueryModel productionLine(String productionLine) {
    this.productionLine = productionLine;
    return this;
  }

   /**
   * 产线
   * @return productionLine
  **/
  @ApiModelProperty(value = "产线")
  public String getProductionLine() {
    return productionLine;
  }

  public void setProductionLine(String productionLine) {
    this.productionLine = productionLine;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsMenuQueryModel menuQueryModel = (MsMenuQueryModel) o;
    return Objects.equals(this.pid, menuQueryModel.pid) &&
        Objects.equals(this.productionLine, menuQueryModel.productionLine);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pid, productionLine);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsMenuQueryModel {\n");
    
    sb.append("    pid: ").append(toIndentedString(pid)).append("\n");
    sb.append("    productionLine: ").append(toIndentedString(productionLine)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
