package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 结算单付款金额信息查询结果
 */
@ApiModel(description = "结算单付款金额信息查询结果")

@JsonInclude(NON_NULL)
public class MsPaymentStatisticResult {
  @JsonProperty("payAmount")
  private String payAmount = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("waitingPayAmount")
  private String waitingPayAmount = null;

  @JsonIgnore
  public MsPaymentStatisticResult payAmount(String payAmount) {
    this.payAmount = payAmount;
    return this;
  }

   /**
   * 已付款金额
   * @return payAmount
  **/
  @ApiModelProperty(value = "已付款金额")
  public String getPayAmount() {
    return payAmount;
  }

  public void setPayAmount(String payAmount) {
    this.payAmount = payAmount;
  }

  @JsonIgnore
  public MsPaymentStatisticResult amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 总含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "总含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsPaymentStatisticResult waitingPayAmount(String waitingPayAmount) {
    this.waitingPayAmount = waitingPayAmount;
    return this;
  }

   /**
   * 未付款金额
   * @return waitingPayAmount
  **/
  @ApiModelProperty(value = "未付款金额")
  public String getWaitingPayAmount() {
    return waitingPayAmount;
  }

  public void setWaitingPayAmount(String waitingPayAmount) {
    this.waitingPayAmount = waitingPayAmount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsPaymentStatisticResult paymentStatisticResult = (MsPaymentStatisticResult) o;
    return Objects.equals(this.payAmount, paymentStatisticResult.payAmount) &&
        Objects.equals(this.amountWithTax, paymentStatisticResult.amountWithTax) &&
        Objects.equals(this.waitingPayAmount, paymentStatisticResult.waitingPayAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payAmount, amountWithTax, waitingPayAmount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsPaymentStatisticResult {\n");
    
    sb.append("    payAmount: ").append(toIndentedString(payAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    waitingPayAmount: ").append(toIndentedString(waitingPayAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
