package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 设置授权登录请求
 */
@ApiModel(description = "设置授权登录请求")

@JsonInclude(NON_NULL)
public class MsSetAuthLoginRequest {
  @JsonProperty("loginId")
  private String loginId = null;

  @JsonProperty("userToken")
  private String userToken = null;

  @JsonIgnore
  public MsSetAuthLoginRequest loginId(String loginId) {
    this.loginId = loginId;
    return this;
  }

   /**
   * 登录Id
   * @return loginId
  **/
  @ApiModelProperty(value = "登录Id")
  public String getLoginId() {
    return loginId;
  }

  public void setLoginId(String loginId) {
    this.loginId = loginId;
  }

  @JsonIgnore
  public MsSetAuthLoginRequest userToken(String userToken) {
    this.userToken = userToken;
    return this;
  }

   /**
   * 用户token
   * @return userToken
  **/
  @ApiModelProperty(value = "用户token")
  public String getUserToken() {
    return userToken;
  }

  public void setUserToken(String userToken) {
    this.userToken = userToken;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSetAuthLoginRequest setAuthLoginRequest = (MsSetAuthLoginRequest) o;
    return Objects.equals(this.loginId, setAuthLoginRequest.loginId) &&
        Objects.equals(this.userToken, setAuthLoginRequest.userToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(loginId, userToken);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSetAuthLoginRequest {\n");
    
    sb.append("    loginId: ").append(toIndentedString(loginId)).append("\n");
    sb.append("    userToken: ").append(toIndentedString(userToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
