package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 申请变更供应商名称请求对象
 */
@ApiModel(description = "申请变更供应商名称请求对象")

@JsonInclude(NON_NULL)
public class MsSsoApplyChangeCmpNameRequest {
  @JsonProperty("purTenantCode")
  private String purTenantCode = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonIgnore
  public MsSsoApplyChangeCmpNameRequest purTenantCode(String purTenantCode) {
    this.purTenantCode = purTenantCode;
    return this;
  }

   /**
   * 购方租户代码
   * @return purTenantCode
  **/
  @ApiModelProperty(value = "购方租户代码")
  public String getPurTenantCode() {
    return purTenantCode;
  }

  public void setPurTenantCode(String purTenantCode) {
    this.purTenantCode = purTenantCode;
  }

  @JsonIgnore
  public MsSsoApplyChangeCmpNameRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 供应商税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "供应商税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsSsoApplyChangeCmpNameRequest sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 供应商名称（新）
   * @return sellerName
  **/
  @ApiModelProperty(value = "供应商名称（新）")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSsoApplyChangeCmpNameRequest ssoApplyChangeCmpNameRequest = (MsSsoApplyChangeCmpNameRequest) o;
    return Objects.equals(this.purTenantCode, ssoApplyChangeCmpNameRequest.purTenantCode) &&
        Objects.equals(this.sellerTaxNo, ssoApplyChangeCmpNameRequest.sellerTaxNo) &&
        Objects.equals(this.sellerName, ssoApplyChangeCmpNameRequest.sellerName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purTenantCode, sellerTaxNo, sellerName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSsoApplyChangeCmpNameRequest {\n");
    
    sb.append("    purTenantCode: ").append(toIndentedString(purTenantCode)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
