package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 手机验证码登录回复
 */
@ApiModel(description = "手机验证码登录回复")

@JsonInclude(NON_NULL)
public class MsSsoSendSmsLoginCodeResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("data")
  private String data = null;

  @JsonIgnore
  public MsSsoSendSmsLoginCodeResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code 0:失败 1:成功
   * @return code
  **/
  @ApiModelProperty(value = "return code 0:失败 1:成功")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsSsoSendSmsLoginCodeResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsSsoSendSmsLoginCodeResponse data(String data) {
    this.data = data;
    return this;
  }

   /**
   * 返回数据
   * @return data
  **/
  @ApiModelProperty(value = "返回数据")
  public String getData() {
    return data;
  }

  public void setData(String data) {
    this.data = data;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSsoSendSmsLoginCodeResponse ssoSendSmsLoginCodeResponse = (MsSsoSendSmsLoginCodeResponse) o;
    return Objects.equals(this.code, ssoSendSmsLoginCodeResponse.code) &&
        Objects.equals(this.message, ssoSendSmsLoginCodeResponse.message) &&
        Objects.equals(this.data, ssoSendSmsLoginCodeResponse.data);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, data);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSsoSendSmsLoginCodeResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
