package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 首页统计请求参数
 */
@ApiModel(description = "首页统计请求参数")

@JsonInclude(NON_NULL)
public class MsStatisticByTypeRequest {
  @JsonProperty("statisticType")
  private Integer statisticType = null;

  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("purchaserTenantId")
  private Long purchaserTenantId = null;

  @JsonIgnore
  public MsStatisticByTypeRequest statisticType(Integer statisticType) {
    this.statisticType = statisticType;
    return this;
  }

   /**
   * 统计类型 0-总待开票数量 1-本月待开票数量 2-本月待开票金额 3-本月已开票金额 4-本月已认证金额 5-结算剩余天数
   * @return statisticType
  **/
  @ApiModelProperty(value = "统计类型 0-总待开票数量 1-本月待开票数量 2-本月待开票金额 3-本月已开票金额 4-本月已认证金额 5-结算剩余天数")
  public Integer getStatisticType() {
    return statisticType;
  }

  public void setStatisticType(Integer statisticType) {
    this.statisticType = statisticType;
  }

  @JsonIgnore
  public MsStatisticByTypeRequest sellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * 销方租户id
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "销方租户id")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public MsStatisticByTypeRequest purchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
    return this;
  }

   /**
   * 协同购方租户id
   * @return purchaserTenantId
  **/
  @ApiModelProperty(value = "协同购方租户id")
  public Long getPurchaserTenantId() {
    return purchaserTenantId;
  }

  public void setPurchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsStatisticByTypeRequest statisticByTypeRequest = (MsStatisticByTypeRequest) o;
    return Objects.equals(this.statisticType, statisticByTypeRequest.statisticType) &&
        Objects.equals(this.sellerTenantId, statisticByTypeRequest.sellerTenantId) &&
        Objects.equals(this.purchaserTenantId, statisticByTypeRequest.purchaserTenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(statisticType, sellerTenantId, purchaserTenantId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsStatisticByTypeRequest {\n");
    
    sb.append("    statisticType: ").append(toIndentedString(statisticType)).append("\n");
    sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
    sb.append("    purchaserTenantId: ").append(toIndentedString(purchaserTenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
