package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询帮助消息model
 */
@ApiModel(description = "查询帮助消息model")

@JsonInclude(NON_NULL)
public class MsSupportQueryModel {
  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("pageIndex")
  private Integer pageIndex = null;

  @JsonProperty("productionLine")
  private String productionLine = null;

  @JsonProperty("menuPid")
  private Long menuPid = null;

  @JsonProperty("menuId")
  private Long menuId = null;

  @JsonProperty("title")
  private String title = null;

  @JsonProperty("keyword")
  private String keyword = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("groupIds")
  private List<Long> groupIds = new ArrayList<Long>();

  @JsonProperty("serviceType")
  private Integer serviceType = null;

  @JsonProperty("opTenantId")
  private Long opTenantId = null;

  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonIgnore
  public MsSupportQueryModel pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 页面展示数据数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "页面展示数据数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsSupportQueryModel pageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
    return this;
  }

   /**
   * 页面当前页数
   * @return pageIndex
  **/
  @ApiModelProperty(value = "页面当前页数")
  public Integer getPageIndex() {
    return pageIndex;
  }

  public void setPageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
  }

  @JsonIgnore
  public MsSupportQueryModel productionLine(String productionLine) {
    this.productionLine = productionLine;
    return this;
  }

   /**
   * 产线
   * @return productionLine
  **/
  @ApiModelProperty(value = "产线")
  public String getProductionLine() {
    return productionLine;
  }

  public void setProductionLine(String productionLine) {
    this.productionLine = productionLine;
  }

  @JsonIgnore
  public MsSupportQueryModel menuPid(Long menuPid) {
    this.menuPid = menuPid;
    return this;
  }

   /**
   * 菜单父iD
   * @return menuPid
  **/
  @ApiModelProperty(value = "菜单父iD")
  public Long getMenuPid() {
    return menuPid;
  }

  public void setMenuPid(Long menuPid) {
    this.menuPid = menuPid;
  }

  @JsonIgnore
  public MsSupportQueryModel menuId(Long menuId) {
    this.menuId = menuId;
    return this;
  }

   /**
   * 菜单id
   * @return menuId
  **/
  @ApiModelProperty(value = "菜单id")
  public Long getMenuId() {
    return menuId;
  }

  public void setMenuId(Long menuId) {
    this.menuId = menuId;
  }

  @JsonIgnore
  public MsSupportQueryModel title(String title) {
    this.title = title;
    return this;
  }

   /**
   * 主题 模糊搜索
   * @return title
  **/
  @ApiModelProperty(value = "主题 模糊搜索")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  @JsonIgnore
  public MsSupportQueryModel keyword(String keyword) {
    this.keyword = keyword;
    return this;
  }

   /**
   * 关键词 模糊搜索
   * @return keyword
  **/
  @ApiModelProperty(value = "关键词 模糊搜索")
  public String getKeyword() {
    return keyword;
  }

  public void setKeyword(String keyword) {
    this.keyword = keyword;
  }

  @JsonIgnore
  public MsSupportQueryModel status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态 1-启用 0-停用
   * @return status
  **/
  @ApiModelProperty(value = "状态 1-启用 0-停用")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsSupportQueryModel groupIds(List<Long> groupIds) {
    this.groupIds = groupIds;
    return this;
  }

  public MsSupportQueryModel addGroupIdsItem(Long groupIdsItem) {
    this.groupIds.add(groupIdsItem);
    return this;
  }

   /**
   * 特定购方租户id集合
   * @return groupIds
  **/
  @ApiModelProperty(value = "特定购方租户id集合")
  public List<Long> getGroupIds() {
    return groupIds;
  }

  public void setGroupIds(List<Long> groupIds) {
    this.groupIds = groupIds;
  }

  @JsonIgnore
  public MsSupportQueryModel serviceType(Integer serviceType) {
    this.serviceType = serviceType;
    return this;
  }

   /**
   * 服务类型 1-直连服务 2-非直连服务 0/空 -全部
   * @return serviceType
  **/
  @ApiModelProperty(value = "服务类型 1-直连服务 2-非直连服务 0/空 -全部")
  public Integer getServiceType() {
    return serviceType;
  }

  public void setServiceType(Integer serviceType) {
    this.serviceType = serviceType;
  }

  @JsonIgnore
  public MsSupportQueryModel opTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
    return this;
  }

   /**
   * 操作用户所属租户id
   * @return opTenantId
  **/
  @ApiModelProperty(value = "操作用户所属租户id")
  public Long getOpTenantId() {
    return opTenantId;
  }

  public void setOpTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
  }

  @JsonIgnore
  public MsSupportQueryModel opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作用户id
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作用户id")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsSupportQueryModel opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作用户名称
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作用户名称")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSupportQueryModel supportQueryModel = (MsSupportQueryModel) o;
    return Objects.equals(this.pageSize, supportQueryModel.pageSize) &&
        Objects.equals(this.pageIndex, supportQueryModel.pageIndex) &&
        Objects.equals(this.productionLine, supportQueryModel.productionLine) &&
        Objects.equals(this.menuPid, supportQueryModel.menuPid) &&
        Objects.equals(this.menuId, supportQueryModel.menuId) &&
        Objects.equals(this.title, supportQueryModel.title) &&
        Objects.equals(this.keyword, supportQueryModel.keyword) &&
        Objects.equals(this.status, supportQueryModel.status) &&
        Objects.equals(this.groupIds, supportQueryModel.groupIds) &&
        Objects.equals(this.serviceType, supportQueryModel.serviceType) &&
        Objects.equals(this.opTenantId, supportQueryModel.opTenantId) &&
        Objects.equals(this.opUserId, supportQueryModel.opUserId) &&
        Objects.equals(this.opUserName, supportQueryModel.opUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageSize, pageIndex, productionLine, menuPid, menuId, title, keyword, status, groupIds, serviceType, opTenantId, opUserId, opUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSupportQueryModel {\n");
    
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    pageIndex: ").append(toIndentedString(pageIndex)).append("\n");
    sb.append("    productionLine: ").append(toIndentedString(productionLine)).append("\n");
    sb.append("    menuPid: ").append(toIndentedString(menuPid)).append("\n");
    sb.append("    menuId: ").append(toIndentedString(menuId)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    keyword: ").append(toIndentedString(keyword)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    groupIds: ").append(toIndentedString(groupIds)).append("\n");
    sb.append("    serviceType: ").append(toIndentedString(serviceType)).append("\n");
    sb.append("    opTenantId: ").append(toIndentedString(opTenantId)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
