package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTCOneStopEnterResponse
 */

@JsonInclude(NON_NULL)
public class MsTCOneStopEnterResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("tenantPassword")
  private String tenantPassword = null;

  @JsonProperty("userPassword")
  private String userPassword = null;

  @JsonIgnore
  public MsTCOneStopEnterResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 代码 0-失败 1-成功
   * @return code
  **/
  @ApiModelProperty(value = "代码 0-失败 1-成功")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsTCOneStopEnterResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 返回信息
   * @return message
  **/
  @ApiModelProperty(value = "返回信息")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsTCOneStopEnterResponse tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID(成功返回)
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID(成功返回)")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsTCOneStopEnterResponse companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司ID(成功返回)
   * @return companyId
  **/
  @ApiModelProperty(value = "公司ID(成功返回)")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsTCOneStopEnterResponse userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户ID(成功返回)
   * @return userId
  **/
  @ApiModelProperty(value = "用户ID(成功返回)")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsTCOneStopEnterResponse tenantPassword(String tenantPassword) {
    this.tenantPassword = tenantPassword;
    return this;
  }

   /**
   * 租户登录密码(成功返回,已加密处理)
   * @return tenantPassword
  **/
  @ApiModelProperty(value = "租户登录密码(成功返回,已加密处理)")
  public String getTenantPassword() {
    return tenantPassword;
  }

  public void setTenantPassword(String tenantPassword) {
    this.tenantPassword = tenantPassword;
  }

  @JsonIgnore
  public MsTCOneStopEnterResponse userPassword(String userPassword) {
    this.userPassword = userPassword;
    return this;
  }

   /**
   * 登录密码(成功返回,已加密处理)
   * @return userPassword
  **/
  @ApiModelProperty(value = "登录密码(成功返回,已加密处理)")
  public String getUserPassword() {
    return userPassword;
  }

  public void setUserPassword(String userPassword) {
    this.userPassword = userPassword;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCOneStopEnterResponse tcOneStopEnterResponse = (MsTCOneStopEnterResponse) o;
    return Objects.equals(this.code, tcOneStopEnterResponse.code) &&
        Objects.equals(this.message, tcOneStopEnterResponse.message) &&
        Objects.equals(this.tenantId, tcOneStopEnterResponse.tenantId) &&
        Objects.equals(this.companyId, tcOneStopEnterResponse.companyId) &&
        Objects.equals(this.userId, tcOneStopEnterResponse.userId) &&
        Objects.equals(this.tenantPassword, tcOneStopEnterResponse.tenantPassword) &&
        Objects.equals(this.userPassword, tcOneStopEnterResponse.userPassword);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, tenantId, companyId, userId, tenantPassword, userPassword);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCOneStopEnterResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    tenantPassword: ").append(toIndentedString(tenantPassword)).append("\n");
    sb.append("    userPassword: ").append(toIndentedString(userPassword)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
