package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 根据税号获取账号请求
 */
@ApiModel(description = "根据税号获取账号请求")

@JsonInclude(NON_NULL)
public class MsTCQueryAccountByTaxNoRequest {
  @JsonProperty("taxNum")
  private String taxNum = null;

  @JsonIgnore
  public MsTCQueryAccountByTaxNoRequest taxNum(String taxNum) {
    this.taxNum = taxNum;
    return this;
  }

   /**
   * 公司税号
   * @return taxNum
  **/
  @ApiModelProperty(value = "公司税号")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCQueryAccountByTaxNoRequest tcQueryAccountByTaxNoRequest = (MsTCQueryAccountByTaxNoRequest) o;
    return Objects.equals(this.taxNum, tcQueryAccountByTaxNoRequest.taxNum);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxNum);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCQueryAccountByTaxNoRequest {\n");
    
    sb.append("    taxNum: ").append(toIndentedString(taxNum)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
