package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsTCTopOrgBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTCQueryTopOrgListResponse
 */

@JsonInclude(NON_NULL)
public class MsTCQueryTopOrgListResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("total")
  private Integer total = null;

  @JsonProperty("result")
  private List<MsTCTopOrgBean> result = new ArrayList<MsTCTopOrgBean>();

  @JsonIgnore
  public MsTCQueryTopOrgListResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsTCQueryTopOrgListResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsTCQueryTopOrgListResponse total(Integer total) {
    this.total = total;
    return this;
  }

   /**
   * 总数量
   * @return total
  **/
  @ApiModelProperty(value = "总数量")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  @JsonIgnore
  public MsTCQueryTopOrgListResponse result(List<MsTCTopOrgBean> result) {
    this.result = result;
    return this;
  }

  public MsTCQueryTopOrgListResponse addResultItem(MsTCTopOrgBean resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 当前页数据
   * @return result
  **/
  @ApiModelProperty(value = "当前页数据")
  public List<MsTCTopOrgBean> getResult() {
    return result;
  }

  public void setResult(List<MsTCTopOrgBean> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCQueryTopOrgListResponse tcQueryTopOrgListResponse = (MsTCQueryTopOrgListResponse) o;
    return Objects.equals(this.code, tcQueryTopOrgListResponse.code) &&
        Objects.equals(this.message, tcQueryTopOrgListResponse.message) &&
        Objects.equals(this.total, tcQueryTopOrgListResponse.total) &&
        Objects.equals(this.result, tcQueryTopOrgListResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, total, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCQueryTopOrgListResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
