package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 角色添加请求对象
 */
@ApiModel(description = "角色添加请求对象")

@JsonInclude(NON_NULL)
public class MsTCRoleAddRequest {
  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("roleCode")
  private String roleCode = null;

  @JsonProperty("roleName")
  private String roleName = null;

  @JsonProperty("roleDesc")
  private String roleDesc = null;

  @JsonProperty("resourcesetIds")
  private List<String> resourcesetIds = new ArrayList<String>();

  @JsonProperty("opUserId")
  private String opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonIgnore
  public MsTCRoleAddRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsTCRoleAddRequest roleCode(String roleCode) {
    this.roleCode = roleCode;
    return this;
  }

   /**
   * 角色代码
   * @return roleCode
  **/
  @ApiModelProperty(value = "角色代码")
  public String getRoleCode() {
    return roleCode;
  }

  public void setRoleCode(String roleCode) {
    this.roleCode = roleCode;
  }

  @JsonIgnore
  public MsTCRoleAddRequest roleName(String roleName) {
    this.roleName = roleName;
    return this;
  }

   /**
   * 角色名称
   * @return roleName
  **/
  @ApiModelProperty(value = "角色名称")
  public String getRoleName() {
    return roleName;
  }

  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }

  @JsonIgnore
  public MsTCRoleAddRequest roleDesc(String roleDesc) {
    this.roleDesc = roleDesc;
    return this;
  }

   /**
   * 角色功能描述
   * @return roleDesc
  **/
  @ApiModelProperty(value = "角色功能描述")
  public String getRoleDesc() {
    return roleDesc;
  }

  public void setRoleDesc(String roleDesc) {
    this.roleDesc = roleDesc;
  }

  @JsonIgnore
  public MsTCRoleAddRequest resourcesetIds(List<String> resourcesetIds) {
    this.resourcesetIds = resourcesetIds;
    return this;
  }

  public MsTCRoleAddRequest addResourcesetIdsItem(String resourcesetIdsItem) {
    this.resourcesetIds.add(resourcesetIdsItem);
    return this;
  }

   /**
   * 功能集集合ID
   * @return resourcesetIds
  **/
  @ApiModelProperty(value = "功能集集合ID")
  public List<String> getResourcesetIds() {
    return resourcesetIds;
  }

  public void setResourcesetIds(List<String> resourcesetIds) {
    this.resourcesetIds = resourcesetIds;
  }

  @JsonIgnore
  public MsTCRoleAddRequest opUserId(String opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public String getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(String opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsTCRoleAddRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人姓名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人姓名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCRoleAddRequest tcRoleAddRequest = (MsTCRoleAddRequest) o;
    return Objects.equals(this.tenantId, tcRoleAddRequest.tenantId) &&
        Objects.equals(this.roleCode, tcRoleAddRequest.roleCode) &&
        Objects.equals(this.roleName, tcRoleAddRequest.roleName) &&
        Objects.equals(this.roleDesc, tcRoleAddRequest.roleDesc) &&
        Objects.equals(this.resourcesetIds, tcRoleAddRequest.resourcesetIds) &&
        Objects.equals(this.opUserId, tcRoleAddRequest.opUserId) &&
        Objects.equals(this.opUserName, tcRoleAddRequest.opUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, roleCode, roleName, roleDesc, resourcesetIds, opUserId, opUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCRoleAddRequest {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    roleCode: ").append(toIndentedString(roleCode)).append("\n");
    sb.append("    roleName: ").append(toIndentedString(roleName)).append("\n");
    sb.append("    roleDesc: ").append(toIndentedString(roleDesc)).append("\n");
    sb.append("    resourcesetIds: ").append(toIndentedString(resourcesetIds)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
