package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 顶层组织信息
 */
@ApiModel(description = "顶层组织信息")

@JsonInclude(NON_NULL)
public class MsTCTopOrgBean {
  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("orgId")
  private Long orgId = null;

  @JsonProperty("orgName")
  private String orgName = null;

  @JsonIgnore
  public MsTCTopOrgBean tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsTCTopOrgBean orgId(Long orgId) {
    this.orgId = orgId;
    return this;
  }

   /**
   * 组织ID
   * @return orgId
  **/
  @ApiModelProperty(value = "组织ID")
  public Long getOrgId() {
    return orgId;
  }

  public void setOrgId(Long orgId) {
    this.orgId = orgId;
  }

  @JsonIgnore
  public MsTCTopOrgBean orgName(String orgName) {
    this.orgName = orgName;
    return this;
  }

   /**
   * 组织名称
   * @return orgName
  **/
  @ApiModelProperty(value = "组织名称")
  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCTopOrgBean tcTopOrgBean = (MsTCTopOrgBean) o;
    return Objects.equals(this.tenantId, tcTopOrgBean.tenantId) &&
        Objects.equals(this.orgId, tcTopOrgBean.orgId) &&
        Objects.equals(this.orgName, tcTopOrgBean.orgName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, orgId, orgName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCTopOrgBean {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    orgId: ").append(toIndentedString(orgId)).append("\n");
    sb.append("    orgName: ").append(toIndentedString(orgName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
