package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 税编结构模型
 */
@ApiModel(description = "税编结构模型")

@JsonInclude(NON_NULL)
public class MsTaxCodeListModel {
  @JsonProperty("taxCode")
  private String taxCode = null;

  @JsonProperty("taxName")
  private String taxName = null;

  @JsonProperty("taxShortName")
  private String taxShortName = null;

  @JsonProperty("taxRateList")
  private List<String> taxRateList = new ArrayList<String>();

  @JsonProperty("taxPolicy")
  private String taxPolicy = null;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonProperty("taxCodeVersion")
  private String taxCodeVersion = null;

  @JsonProperty("effectiveDate")
  private String effectiveDate = null;

  @JsonProperty("expirationDate")
  private String expirationDate = null;

  @JsonProperty("specialManagement")
  private String specialManagement = null;

  @JsonIgnore
  public MsTaxCodeListModel taxCode(String taxCode) {
    this.taxCode = taxCode;
    return this;
  }

   /**
   * 税收分类编码（非末级税编）
   * @return taxCode
  **/
  @ApiModelProperty(value = "税收分类编码（非末级税编）")
  public String getTaxCode() {
    return taxCode;
  }

  public void setTaxCode(String taxCode) {
    this.taxCode = taxCode;
  }

  @JsonIgnore
  public MsTaxCodeListModel taxName(String taxName) {
    this.taxName = taxName;
    return this;
  }

   /**
   * 税编名称
   * @return taxName
  **/
  @ApiModelProperty(value = "税编名称")
  public String getTaxName() {
    return taxName;
  }

  public void setTaxName(String taxName) {
    this.taxName = taxName;
  }

  @JsonIgnore
  public MsTaxCodeListModel taxShortName(String taxShortName) {
    this.taxShortName = taxShortName;
    return this;
  }

   /**
   * 税编简称
   * @return taxShortName
  **/
  @ApiModelProperty(value = "税编简称")
  public String getTaxShortName() {
    return taxShortName;
  }

  public void setTaxShortName(String taxShortName) {
    this.taxShortName = taxShortName;
  }

  @JsonIgnore
  public MsTaxCodeListModel taxRateList(List<String> taxRateList) {
    this.taxRateList = taxRateList;
    return this;
  }

  public MsTaxCodeListModel addTaxRateListItem(String taxRateListItem) {
    this.taxRateList.add(taxRateListItem);
    return this;
  }

   /**
   * Get taxRateList
   * @return taxRateList
  **/
  @ApiModelProperty(value = "")
  public List<String> getTaxRateList() {
    return taxRateList;
  }

  public void setTaxRateList(List<String> taxRateList) {
    this.taxRateList = taxRateList;
  }

  @JsonIgnore
  public MsTaxCodeListModel taxPolicy(String taxPolicy) {
    this.taxPolicy = taxPolicy;
    return this;
  }

   /**
   * 可用的优惠政策内容
   * @return taxPolicy
  **/
  @ApiModelProperty(value = "可用的优惠政策内容")
  public String getTaxPolicy() {
    return taxPolicy;
  }

  public void setTaxPolicy(String taxPolicy) {
    this.taxPolicy = taxPolicy;
  }

  @JsonIgnore
  public MsTaxCodeListModel zeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 零税率标识
   * @return zeroTax
  **/
  @ApiModelProperty(value = "零税率标识")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }

  @JsonIgnore
  public MsTaxCodeListModel taxCodeVersion(String taxCodeVersion) {
    this.taxCodeVersion = taxCodeVersion;
    return this;
  }

   /**
   * 税编版本号
   * @return taxCodeVersion
  **/
  @ApiModelProperty(value = "税编版本号")
  public String getTaxCodeVersion() {
    return taxCodeVersion;
  }

  public void setTaxCodeVersion(String taxCodeVersion) {
    this.taxCodeVersion = taxCodeVersion;
  }

  @JsonIgnore
  public MsTaxCodeListModel effectiveDate(String effectiveDate) {
    this.effectiveDate = effectiveDate;
    return this;
  }

   /**
   * 生效日期（yyyyMMdd）
   * @return effectiveDate
  **/
  @ApiModelProperty(value = "生效日期（yyyyMMdd）")
  public String getEffectiveDate() {
    return effectiveDate;
  }

  public void setEffectiveDate(String effectiveDate) {
    this.effectiveDate = effectiveDate;
  }

  @JsonIgnore
  public MsTaxCodeListModel expirationDate(String expirationDate) {
    this.expirationDate = expirationDate;
    return this;
  }

   /**
   * 过渡期截止日期（yyyyMMdd）
   * @return expirationDate
  **/
  @ApiModelProperty(value = "过渡期截止日期（yyyyMMdd）")
  public String getExpirationDate() {
    return expirationDate;
  }

  public void setExpirationDate(String expirationDate) {
    this.expirationDate = expirationDate;
  }

  @JsonIgnore
  public MsTaxCodeListModel specialManagement(String specialManagement) {
    this.specialManagement = specialManagement;
    return this;
  }

   /**
   * 特殊管理
   * @return specialManagement
  **/
  @ApiModelProperty(value = "特殊管理")
  public String getSpecialManagement() {
    return specialManagement;
  }

  public void setSpecialManagement(String specialManagement) {
    this.specialManagement = specialManagement;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxCodeListModel taxCodeListModel = (MsTaxCodeListModel) o;
    return Objects.equals(this.taxCode, taxCodeListModel.taxCode) &&
        Objects.equals(this.taxName, taxCodeListModel.taxName) &&
        Objects.equals(this.taxShortName, taxCodeListModel.taxShortName) &&
        Objects.equals(this.taxRateList, taxCodeListModel.taxRateList) &&
        Objects.equals(this.taxPolicy, taxCodeListModel.taxPolicy) &&
        Objects.equals(this.zeroTax, taxCodeListModel.zeroTax) &&
        Objects.equals(this.taxCodeVersion, taxCodeListModel.taxCodeVersion) &&
        Objects.equals(this.effectiveDate, taxCodeListModel.effectiveDate) &&
        Objects.equals(this.expirationDate, taxCodeListModel.expirationDate) &&
        Objects.equals(this.specialManagement, taxCodeListModel.specialManagement);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxCode, taxName, taxShortName, taxRateList, taxPolicy, zeroTax, taxCodeVersion, effectiveDate, expirationDate, specialManagement);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxCodeListModel {\n");
    
    sb.append("    taxCode: ").append(toIndentedString(taxCode)).append("\n");
    sb.append("    taxName: ").append(toIndentedString(taxName)).append("\n");
    sb.append("    taxShortName: ").append(toIndentedString(taxShortName)).append("\n");
    sb.append("    taxRateList: ").append(toIndentedString(taxRateList)).append("\n");
    sb.append("    taxPolicy: ").append(toIndentedString(taxPolicy)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("    taxCodeVersion: ").append(toIndentedString(taxCodeVersion)).append("\n");
    sb.append("    effectiveDate: ").append(toIndentedString(effectiveDate)).append("\n");
    sb.append("    expirationDate: ").append(toIndentedString(expirationDate)).append("\n");
    sb.append("    specialManagement: ").append(toIndentedString(specialManagement)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
