package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTaxCodeModel
 */

@JsonInclude(NON_NULL)
public class MsTaxCodeModel {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("taxcodeName")
  private String taxcodeName = null;

  @JsonProperty("goodsTaxNo")
  private String goodsTaxNo = null;

  @JsonProperty("taxcodeShortName")
  private String taxcodeShortName = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxPre")
  private String taxPre = null;

  @JsonProperty("taxPreCon")
  private String taxPreCon = null;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonIgnore
  public MsTaxCodeModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsTaxCodeModel taxcodeName(String taxcodeName) {
    this.taxcodeName = taxcodeName;
    return this;
  }

   /**
   * 税编名称
   * @return taxcodeName
  **/
  @ApiModelProperty(value = "税编名称")
  public String getTaxcodeName() {
    return taxcodeName;
  }

  public void setTaxcodeName(String taxcodeName) {
    this.taxcodeName = taxcodeName;
  }

  @JsonIgnore
  public MsTaxCodeModel goodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
    return this;
  }

   /**
   * 税收编码
   * @return goodsTaxNo
  **/
  @ApiModelProperty(value = "税收编码")
  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  @JsonIgnore
  public MsTaxCodeModel taxcodeShortName(String taxcodeShortName) {
    this.taxcodeShortName = taxcodeShortName;
    return this;
  }

   /**
   * 税编简称
   * @return taxcodeShortName
  **/
  @ApiModelProperty(value = "税编简称")
  public String getTaxcodeShortName() {
    return taxcodeShortName;
  }

  public void setTaxcodeShortName(String taxcodeShortName) {
    this.taxcodeShortName = taxcodeShortName;
  }

  @JsonIgnore
  public MsTaxCodeModel taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public MsTaxCodeModel taxPre(String taxPre) {
    this.taxPre = taxPre;
    return this;
  }

   /**
   * 是否享受优惠政策， 0 否， 1 是
   * @return taxPre
  **/
  @ApiModelProperty(value = "是否享受优惠政策， 0 否， 1 是")
  public String getTaxPre() {
    return taxPre;
  }

  public void setTaxPre(String taxPre) {
    this.taxPre = taxPre;
  }

  @JsonIgnore
  public MsTaxCodeModel taxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
    return this;
  }

   /**
   * 优惠政策内容
   * @return taxPreCon
  **/
  @ApiModelProperty(value = "优惠政策内容")
  public String getTaxPreCon() {
    return taxPreCon;
  }

  public void setTaxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
  }

  @JsonIgnore
  public MsTaxCodeModel zeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 零税率标识， 0 出口退税， 1 免税，2 不征税， 2 普通零税率
   * @return zeroTax
  **/
  @ApiModelProperty(value = "零税率标识， 0 出口退税， 1 免税，2 不征税， 2 普通零税率")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxCodeModel taxCodeModel = (MsTaxCodeModel) o;
    return Objects.equals(this.id, taxCodeModel.id) &&
        Objects.equals(this.taxcodeName, taxCodeModel.taxcodeName) &&
        Objects.equals(this.goodsTaxNo, taxCodeModel.goodsTaxNo) &&
        Objects.equals(this.taxcodeShortName, taxCodeModel.taxcodeShortName) &&
        Objects.equals(this.taxRate, taxCodeModel.taxRate) &&
        Objects.equals(this.taxPre, taxCodeModel.taxPre) &&
        Objects.equals(this.taxPreCon, taxCodeModel.taxPreCon) &&
        Objects.equals(this.zeroTax, taxCodeModel.zeroTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, taxcodeName, goodsTaxNo, taxcodeShortName, taxRate, taxPre, taxPreCon, zeroTax);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxCodeModel {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    taxcodeName: ").append(toIndentedString(taxcodeName)).append("\n");
    sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
    sb.append("    taxcodeShortName: ").append(toIndentedString(taxcodeShortName)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxPre: ").append(toIndentedString(taxPre)).append("\n");
    sb.append("    taxPreCon: ").append(toIndentedString(taxPreCon)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
