package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 税盘抽取商品请求
 */
@ApiModel(description = "税盘抽取商品请求")

@JsonInclude(NON_NULL)
public class MsTwareGoodsExtractRequest {
  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("purchaserTenantId")
  private Long purchaserTenantId = null;

  @JsonProperty("terminalUn")
  private String terminalUn = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonIgnore
  public MsTwareGoodsExtractRequest sellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * 销方租户id
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "销方租户id")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public MsTwareGoodsExtractRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsTwareGoodsExtractRequest purchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
    return this;
  }

   /**
   * 购方租户id
   * @return purchaserTenantId
  **/
  @ApiModelProperty(value = "购方租户id")
  public Long getPurchaserTenantId() {
    return purchaserTenantId;
  }

  public void setPurchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
  }

  @JsonIgnore
  public MsTwareGoodsExtractRequest terminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
    return this;
  }

   /**
   * 终端UN
   * @return terminalUn
  **/
  @ApiModelProperty(value = "终端UN")
  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }

  @JsonIgnore
  public MsTwareGoodsExtractRequest deviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

   /**
   * 税盘UN
   * @return deviceUn
  **/
  @ApiModelProperty(value = "税盘UN")
  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public MsTwareGoodsExtractRequest companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsTwareGoodsExtractRequest companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTwareGoodsExtractRequest twareGoodsExtractRequest = (MsTwareGoodsExtractRequest) o;
    return Objects.equals(this.sellerTenantId, twareGoodsExtractRequest.sellerTenantId) &&
        Objects.equals(this.userId, twareGoodsExtractRequest.userId) &&
        Objects.equals(this.purchaserTenantId, twareGoodsExtractRequest.purchaserTenantId) &&
        Objects.equals(this.terminalUn, twareGoodsExtractRequest.terminalUn) &&
        Objects.equals(this.deviceUn, twareGoodsExtractRequest.deviceUn) &&
        Objects.equals(this.companyTaxNo, twareGoodsExtractRequest.companyTaxNo) &&
        Objects.equals(this.companyName, twareGoodsExtractRequest.companyName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerTenantId, userId, purchaserTenantId, terminalUn, deviceUn, companyTaxNo, companyName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTwareGoodsExtractRequest {\n");
    
    sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    purchaserTenantId: ").append(toIndentedString(purchaserTenantId)).append("\n");
    sb.append("    terminalUn: ").append(toIndentedString(terminalUn)).append("\n");
    sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
