package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 更新授权登录状态请求
 */
@ApiModel(description = "更新授权登录状态请求")

@JsonInclude(NON_NULL)
public class MsUpdateAuthLoginStatusRequest {
  @JsonProperty("loginId")
  private String loginId = null;

  @JsonProperty("status")
  private String status = null;

  @JsonIgnore
  public MsUpdateAuthLoginStatusRequest loginId(String loginId) {
    this.loginId = loginId;
    return this;
  }

   /**
   * 登录Id
   * @return loginId
  **/
  @ApiModelProperty(value = "登录Id")
  public String getLoginId() {
    return loginId;
  }

  public void setLoginId(String loginId) {
    this.loginId = loginId;
  }

  @JsonIgnore
  public MsUpdateAuthLoginStatusRequest status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 登录状态
   * @return status
  **/
  @ApiModelProperty(value = "登录状态")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUpdateAuthLoginStatusRequest updateAuthLoginStatusRequest = (MsUpdateAuthLoginStatusRequest) o;
    return Objects.equals(this.loginId, updateAuthLoginStatusRequest.loginId) &&
        Objects.equals(this.status, updateAuthLoginStatusRequest.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(loginId, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUpdateAuthLoginStatusRequest {\n");
    
    sb.append("    loginId: ").append(toIndentedString(loginId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
