package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsUpdateCoordinationStatusRequest
 */

@JsonInclude(NON_NULL)
public class MsUpdateCoordinationStatusRequest {
  @JsonProperty("purchaserTenantCode")
  private String purchaserTenantCode = null;

  @JsonProperty("purchaserTenantId")
  private Long purchaserTenantId = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonIgnore
  public MsUpdateCoordinationStatusRequest purchaserTenantCode(String purchaserTenantCode) {
    this.purchaserTenantCode = purchaserTenantCode;
    return this;
  }

   /**
   * 协同购方租户代码
   * @return purchaserTenantCode
  **/
  @ApiModelProperty(value = "协同购方租户代码")
  public String getPurchaserTenantCode() {
    return purchaserTenantCode;
  }

  public void setPurchaserTenantCode(String purchaserTenantCode) {
    this.purchaserTenantCode = purchaserTenantCode;
  }

  @JsonIgnore
  public MsUpdateCoordinationStatusRequest purchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
    return this;
  }

   /**
   * 购方租户Id
   * @return purchaserTenantId
  **/
  @ApiModelProperty(value = "购方租户Id")
  public Long getPurchaserTenantId() {
    return purchaserTenantId;
  }

  public void setPurchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
  }

  @JsonIgnore
  public MsUpdateCoordinationStatusRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 协同销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "协同销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsUpdateCoordinationStatusRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 0-停用 1-启用 2-下线
   * @return status
  **/
  @ApiModelProperty(value = "0-停用 1-启用 2-下线")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsUpdateCoordinationStatusRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作用户Id
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作用户Id")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsUpdateCoordinationStatusRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作用户名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作用户名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUpdateCoordinationStatusRequest updateCoordinationStatusRequest = (MsUpdateCoordinationStatusRequest) o;
    return Objects.equals(this.purchaserTenantCode, updateCoordinationStatusRequest.purchaserTenantCode) &&
        Objects.equals(this.purchaserTenantId, updateCoordinationStatusRequest.purchaserTenantId) &&
        Objects.equals(this.sellerTaxNo, updateCoordinationStatusRequest.sellerTaxNo) &&
        Objects.equals(this.status, updateCoordinationStatusRequest.status) &&
        Objects.equals(this.opUserId, updateCoordinationStatusRequest.opUserId) &&
        Objects.equals(this.opUserName, updateCoordinationStatusRequest.opUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purchaserTenantCode, purchaserTenantId, sellerTaxNo, status, opUserId, opUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUpdateCoordinationStatusRequest {\n");
    
    sb.append("    purchaserTenantCode: ").append(toIndentedString(purchaserTenantCode)).append("\n");
    sb.append("    purchaserTenantId: ").append(toIndentedString(purchaserTenantId)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
