package com.xforceplus.ant.system.client.model.goods;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 批量商品同步（修改/添加）
 *
 * @Author xiezhongyong
 * @Date 2021-12-02
 */
@Data
public class BatchGoodsSyncReq {

    @ApiModelProperty("操作用户ID")
    private Long userId;
    @ApiModelProperty("操作用户名称")
    private String userName;
    @ApiModelProperty("操作人租户Id")
    private Long tenantId;

    @ApiModelProperty("商品同步信息列表")
    private List<SynGoods> SynGoodsList;

    @Data
    public static class SynGoods {
        @ApiModelProperty("公司id")
        private Long companyId;
        @ApiModelProperty("税号")
        private String companyTaxNo;
        @ApiModelProperty("公司名称")
        private String companyName;
        @ApiModelProperty("商品编号")
        private String goodsNo;
        @ApiModelProperty("商品名称")
        private String goodsName;
        @ApiModelProperty("规格")
        private String specification;
        @ApiModelProperty("单位")
        private String quantityUnit;
        @ApiModelProperty("计价方式")
        private Integer priceMethod;
        @ApiModelProperty("单价")
        private String unitPrice;
        @ApiModelProperty("商品分类")
        private String goodsClassification;
        @ApiModelProperty("商品分类详情")
        private String goodsClassificationDetail;
        @ApiModelProperty("税转代码")
        private String conversionCode;
        @ApiModelProperty("税编")
        private String taxCode;
        @ApiModelProperty("税编名称")
        private String taxName;
        @ApiModelProperty("税编简称")
        private String taxShortName;
        @ApiModelProperty("税率")
        private String taxRate;
        @ApiModelProperty("是否享受优惠政策")
        private Integer taxPre;
        @ApiModelProperty("优惠政策内容")
        private String taxPreCon;
        @ApiModelProperty("即征即退类型")
        private String taxCollectionRefundDetail;
        @ApiModelProperty("零税率标志")
        private String zeroTax;
        @ApiModelProperty("协同商品类型")
        private Integer coopGoodsType;
        @ApiModelProperty("协同租户id")
        private Long coopTenantId;
        @ApiModelProperty("协同租户名称")
        private String coopTenantName;
        @ApiModelProperty("协同租户代码")
        private String coopTenantCode;
        @ApiModelProperty("协同公司代码")
        private String coopCompanyCode;
        @ApiModelProperty("协同公司名称")
        private String coopCompanyName;
        @ApiModelProperty("协同公司税号")
        private String coopCompanyTaxNo;
        @ApiModelProperty("协同商品编号")
        private String coopGoodsNo;
        @ApiModelProperty("协同商品名称")
        private String coopGoodsName;
        @ApiModelProperty("协同商品规格")
        private String coopSpecification;
        @ApiModelProperty("协同商品单位")
        private String coopQuantityUnit;
        @ApiModelProperty("协同商品计价方式")
        private Integer coopPriceMethod;
        @ApiModelProperty("协同商品单价")
        private String coopUnitPrice;
        @ApiModelProperty("协同商品税编")
        private String coopTaxCode;
        @ApiModelProperty("协同商品税编名称")
        private String coopTaxName;
        @ApiModelProperty("协同商品税编简称")
        private String coopTaxShortName;
        @ApiModelProperty("协同商品税率")
        private String coopTaxRate;
        @ApiModelProperty("协同商品是否享受优惠政策")
        private Integer coopTaxPre;
        @ApiModelProperty("协同商品优惠政策内容")
        private String coopTaxPreCon;
        @ApiModelProperty("协同商品零税率标志")
        private String coopZeroTax;
    }

}
