package com.xforceplus.ant.system.client.model.goods;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * Describe: 创建商品审核
 *
 * @Author xiezhongyong
 * @Date 2022-07-18
 */
@Data
public class CancelGoodsAuditReq {

    @ApiModelProperty("销方租户id")
    private Long sellerTenantId;

    @ApiModelProperty("操作用户ID")
    private String submitUserId;

    @ApiModelProperty("操作用户名称")
    private String submitUserName;

    @Size(min = 1, max = 100, message = "数据ID列表 范围[1-100]")
    @NotNull(message = "数据ID列表 不能为空")
    @ApiModelProperty("数据ID列表")
    private List<Long> idList;



}
