package com.xforceplus.ant.system.client.model.goods;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * Describe: 创建商品审核
 *
 * @Author xiezhongyong
 * @Date 2022-07-18
 */
@Data
public class CreateGoodsAuditReq {


    @ApiModelProperty("销方租户id")
    private Long sellerTenantId;

    @ApiModelProperty("销方税号")
    private String sellerTaxNo;

    @ApiModelProperty("购方租户id")
    private Long purchaserTenantId;

    @ApiModelProperty("购方税号")
    private String purchaserTaxNo;

    @ApiModelProperty("销方企业名称")
    private String sellerCompanyName;

    @ApiModelProperty("购方的企业名称")
    private String purchaserCompanyName;

    @ApiModelProperty("操作用户ID")
    private String submitUserId;

    @ApiModelProperty("操作用户名称")
    private String submitUserName;


    @Valid
    @NotNull(message = "审核商品列表 不能为空")
    @Size(min = 1, message = "审核商品列表 不能为空")
    @ApiModelProperty("审核商品列表")
    private List<AuditGoodsData> auditGoodsList;

    @Data
    public static class AuditGoodsData{

        @ApiModelProperty("商品编码")
        private String goodsNo;

        @ApiModelProperty("税转代码")
        private String taxConvertCode;

        @Valid
        @NotNull(message = "审核字段列表 不能为空")
        @Size(min = 1,max = 100, message = "审核字段列表 范围[1-100]")
        @ApiModelProperty("审核字段列表")
        private List<AuditField> AuditFields;
    }

    @Data
    public static class AuditField{

        @NotEmpty(message = "字段名 不能为空")
        @ApiModelProperty("字段名")
        private String fieldName;

        @NotEmpty(message = "字段值 不能为空")
        @ApiModelProperty("字段值")
        private String fieldValue;
    }


}
