package com.xforceplus.ant.system.client.tool;

import com.xforceplus.ant.system.client.api.kylin.KylinBillApi;
import com.xforceplus.ant.system.client.model.kylin.KylinResponse;
import com.xforceplus.phoenix.kylin.service.pojo.dto.bill.Bill;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.json.JsonUtils;
import lombok.extern.slf4j.Slf4j;

/**
 * Describe: KylinBillTools
 *
 * @Author xiezhongyong
 * @Date 2022-12-28
 */
@Slf4j
public class KylinBillTools {


    /**
     * 结算单特殊业务保存
     *
     * @param api
     * @param bill
     */
    public static void saveBill(KylinBillApi api, Bill bill) {
        log.info("结算单特殊业务保存请求: {}", JsonUtils.writeObjectToJson(bill));
        KylinResponse<String> response = api.saveBill(bill);
        log.info("结算单特殊业务保存响应: {}", JsonUtils.writeObjectToJson(response));
        if (!Response.OK.toString().equals(response.getCode())) {
            throw new RuntimeException("结算单特殊业务保存失败");
        }
    }

    /**
     * 结算单特殊业务删除
     *
     * @param api
     * @param id
     */
    public static void deleteBill(KylinBillApi api, String id) {
        log.info("结算单特殊业务删除请求: {}", id);
        KylinResponse<String> response = api.deleteBill(id);
        log.info("结算单特殊业务删除响应: {}", JsonUtils.writeObjectToJson(response));
        if (!Response.OK.toString().equals(response.getCode())) {
            throw new RuntimeException("结算单特殊业务删除失败");
        }
    }

    /**
     * 结算单特殊业务删除
     *
     * @param api
     * @param bill
     */
    public static void updateBill(KylinBillApi api, Bill bill) {
        log.info("结算单特殊业务修改请求: {}", JsonUtils.writeObjectToJson(bill));
        KylinResponse<String> response = api.updateBill(bill);
        log.info("结算单特殊业务修改响应: {}", JsonUtils.writeObjectToJson(response));
        if (!Response.OK.toString().equals(response.getCode())) {
            throw new RuntimeException("结算单特殊业务修改失败");
        }
    }

    /**
     * 结算单特殊业务获取
     *
     * @param api
     * @param id
     */
    public static Bill getBill(KylinBillApi api, String id) {
        log.info("获取结算单特殊业务请求: {}", id);
        KylinResponse<Bill> response = api.getBill(id);
        log.info("获取结算单特殊业务响应: {}", JsonUtils.writeObjectToJson(response));
        if (!Response.OK.toString().equals(response.getCode())) {
            throw new RuntimeException("结算单特殊业务修改失败");
        }
        return response.getResult();
    }

}
