/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.common.ws.validator;

import com.xforceplus.ant.coop.common.ws.validator.ParamDesc;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ParamDescValidator
implements ConstraintValidator<ParamDesc, Object> {
    private static final Logger log = LoggerFactory.getLogger(ParamDescValidator.class);
    private ParamDesc check;

    public void initialize(ParamDesc check) {
        this.check = check;
    }

    public boolean isValid(Object o, ConstraintValidatorContext context) {
        if (!ConstraintValidatorContextImpl.class.isAssignableFrom(context.getClass())) {
            log.warn("##### isValid ConstraintValidatorContext \u5b9e\u73b0\u7c7b\u4e3a\u975e ConstraintValidatorContextImpl\uff1a{}", context.getClass());
            return true;
        }
        String fileName = this.check.value();
        String result = null;
        if (null == result && this.check.notEmpty()) {
            result = this.notEmpty(o, fileName);
        }
        if (null == result && !StringUtils.isEmpty((Object)this.check.pattern())) {
            result = this.pattern(o, fileName);
        }
        if (null == result) {
            return true;
        }
        String messageTemplate = context.getDefaultConstraintMessageTemplate();
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(!StringUtils.isEmpty((Object)messageTemplate) ? messageTemplate : result).addConstraintViolation();
        return false;
    }

    private String notEmpty(Object object, String fieldName) {
        if (!this.check.notEmpty()) {
            return null;
        }
        if (null == object) {
            return String.format("%s \u4e0d\u80fd\u4e3a\u7a7a", fieldName);
        }
        String objStr = object.toString();
        if (StringUtils.isEmpty((Object)objStr)) {
            return String.format("%s \u4e0d\u80fd\u4e3a\u7a7a", fieldName);
        }
        return null;
    }

    private String pattern(Object object, String fieldName) {
        if (StringUtils.isEmpty((Object)this.check.pattern())) {
            return null;
        }
        String objStr = object.toString();
        if (!objStr.matches(this.check.pattern())) {
            return String.format("%s \u4e0d\u5408\u6cd5", fieldName);
        }
        return null;
    }
}

