/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.coop.common.ws.validator;

import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class ParamValidatorUtil {
    public static String checkParamsStr(Object input) {
        return ParamValidatorUtil.checkParamsStr(input, true);
    }

    public static String checkParamsStr(Object input, boolean failFast) {
        Set<ConstraintViolation<Object>> constraintViolations = ParamValidatorUtil.checkParamsSets(input, failFast);
        String message = constraintViolations.stream().map(fieldError -> String.format("[%s] %s", fieldError.getPropertyPath(), fieldError.getMessage())).collect(Collectors.joining(";"));
        return message;
    }

    public static <T> Set<ConstraintViolation<T>> checkParamsSets(T input, boolean failFast) {
        ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(failFast).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        return validator.validate(input, new Class[0]);
    }
}

