package com.xforceplus.ant.distribute.client.api;

import com.xforceplus.ant.distribute.client.data.utils.sqs.request.SqsMessage;
import com.xforceplus.ant.distribute.client.data.utils.BaseResult;
import com.xforceplus.ant.distribute.client.data.utils.sqs.response.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * Describe: sqs 消息发送 API
 *
 * @Author xiezhongyong
 * @Date 2021-01-14
 */
@Api(value = "sqs-message", description = "sqs 消息发送 接口服务")
public interface SqsMessageApi {

    @Deprecated
    @ApiOperation("消息发送")
    @RequestMapping(value = "/answers-message", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Result> sqsMessage(@RequestBody @Valid SqsMessage input);


    @ApiOperation("sqs消息发送")
    @RequestMapping(value = "/sqs-message", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Result> sendSqsMessage(@RequestBody @Valid SqsMessage input);

}
