package com.xforceplus.ant.distribute.client.data.utils.sqs.tool;

import com.xforceplus.ant.distribute.client.api.SqsMessageApi;
import com.xforceplus.ant.distribute.client.data.utils.BaseResult;
import com.xforceplus.ant.distribute.client.data.utils.sqs.request.SqsMessage;
import com.xforceplus.ant.distribute.client.data.utils.sqs.response.Result;
import com.xforceplus.xplatframework.utils.json.JsonUtils;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * Describe: sqs 消息发送工具类
 *
 * @Author xiezhongyong
 * @Date 2021-01-18
 */
@Slf4j
public class SqsTool {

    public static Result sendMessage(SqsMessageApi api, String queueName, String message, Map<String, String> properties) {
        try {
            SqsMessage sqsMessage = new SqsMessage();
            sqsMessage.setQueueName(queueName);
            sqsMessage.setMessage(message);
            sqsMessage.setProperties(properties);
            log.info("##### sqs 消息发送请求：{}", JsonUtils.writeObjectToJson(sqsMessage));
            BaseResult<Result> resultBaseResult = api.sendSqsMessage(sqsMessage);
            log.info("##### sqs 消息发送响应：{}", JsonUtils.writeObjectToJson(resultBaseResult));
            if (1 != resultBaseResult.getCode()) {
                return getFailResult(resultBaseResult.getMessage());
            }
            return resultBaseResult.getResult();
        } catch (Exception e) {
            log.error("##### sqs 消息发送请求异常：{}", e);
            return getFailResult(e.getMessage());
        }


    }

    private static Result getFailResult(String message) {
        Result es = new Result();
        es.setExcept("http error");
        es.setMessage(null == message ? "请求微服务data 发送sqs 异常" : message);
        es.setSuc(false);
        return es;
    }
}
