/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.distribute.config;

import com.xforceplus.ant.distribute.config.CoopSqsProperties;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@ConfigurationProperties(prefix="coop.sqs")
@Configuration
public class CoopSqsProperties {
    private static final Logger log = LoggerFactory.getLogger(CoopSqsProperties.class);
    private boolean sendQueueCheck = false;
    private Map<String, QueueConfig> sendConfig = new HashMap();
    private Map<String, QueueConfig> receiveConfig = new HashMap();
    private Map<String, String> rewritePrefixConfig = new HashMap();

    public CoopSqsProperties() {
        log.info("##### init CoopSqsProperties");
    }

    public QueueConfig getSendConfig(String name) {
        return (QueueConfig)this.sendConfig.get(name);
    }

    public QueueConfig getReceiveConfig(String name) {
        return (QueueConfig)this.receiveConfig.get(name);
    }

    public String getRewritePrefixConfig(String name) {
        return (String)this.rewritePrefixConfig.get(name);
    }

    public void setSendConfig(Map<String, QueueConfig> config) {
        this.sendConfig = config;
        config.forEach((key, value) -> value.setName(key));
    }

    public void setReceiveConfig(Map<String, QueueConfig> config) {
        this.receiveConfig = config;
        config.forEach((key, value) -> value.setName(key));
    }

    public boolean isSendQueueCheck() {
        return this.sendQueueCheck;
    }

    public Map<String, QueueConfig> getSendConfig() {
        return this.sendConfig;
    }

    public Map<String, QueueConfig> getReceiveConfig() {
        return this.receiveConfig;
    }

    public Map<String, String> getRewritePrefixConfig() {
        return this.rewritePrefixConfig;
    }

    public void setSendQueueCheck(boolean sendQueueCheck) {
        this.sendQueueCheck = sendQueueCheck;
    }

    public void setRewritePrefixConfig(Map<String, String> rewritePrefixConfig) {
        this.rewritePrefixConfig = rewritePrefixConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoopSqsProperties)) {
            return false;
        }
        CoopSqsProperties other = (CoopSqsProperties)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSendQueueCheck() != other.isSendQueueCheck()) {
            return false;
        }
        Map this$sendConfig = this.getSendConfig();
        Map other$sendConfig = other.getSendConfig();
        if (this$sendConfig == null ? other$sendConfig != null : !((Object)this$sendConfig).equals(other$sendConfig)) {
            return false;
        }
        Map this$receiveConfig = this.getReceiveConfig();
        Map other$receiveConfig = other.getReceiveConfig();
        if (this$receiveConfig == null ? other$receiveConfig != null : !((Object)this$receiveConfig).equals(other$receiveConfig)) {
            return false;
        }
        Map this$rewritePrefixConfig = this.getRewritePrefixConfig();
        Map other$rewritePrefixConfig = other.getRewritePrefixConfig();
        return !(this$rewritePrefixConfig == null ? other$rewritePrefixConfig != null : !((Object)this$rewritePrefixConfig).equals(other$rewritePrefixConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CoopSqsProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSendQueueCheck() ? 79 : 97);
        Map $sendConfig = this.getSendConfig();
        result = result * 59 + ($sendConfig == null ? 43 : ((Object)$sendConfig).hashCode());
        Map $receiveConfig = this.getReceiveConfig();
        result = result * 59 + ($receiveConfig == null ? 43 : ((Object)$receiveConfig).hashCode());
        Map $rewritePrefixConfig = this.getRewritePrefixConfig();
        result = result * 59 + ($rewritePrefixConfig == null ? 43 : ((Object)$rewritePrefixConfig).hashCode());
        return result;
    }

    public String toString() {
        return "CoopSqsProperties(sendQueueCheck=" + this.isSendQueueCheck() + ", sendConfig=" + this.getSendConfig() + ", receiveConfig=" + this.getReceiveConfig() + ", rewritePrefixConfig=" + this.getRewritePrefixConfig() + ")";
    }
}

