/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.distribute.listener.inte;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.distribute.enums.SqsQueueEnum;
import com.xforceplus.ant.distribute.service.DistributeService;
import com.xforceplus.apollo.client.netty.IMessageListener;
import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.xplat.aws.sqs.SqsService;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PurchaserInvoiceListener
implements IMessageListener {
    private Logger logger = LoggerFactory.getLogger(PurchaserInvoiceListener.class);
    private static final String purchaserInvoiceSync = "purchaserInvoiceSync";
    private static final String billPushv4 = "billPushv4";
    private static final String messagePush = "ant-push-message-sync";
    @Autowired
    MCFactory mcFactory;
    @Autowired
    SqsService sqsService;
    @Autowired
    DistributeService distributeService;
    @Value(value="${ant.intergration.distribute.purchaserTenantIds}")
    public String purchaserTenantIds;
    @Value(value="${ant.intergration.distribute.wilmar}")
    public String wilmar;
    @Value(value="${ant.intergration.distribute.baolong}")
    public String baolong;

    @PostConstruct
    private void init() {
        this.mcFactory.registerListener((IMessageListener)this);
    }

    public boolean onMessage(SealedMessage sealedMessage) {
        this.logger.info("\u76d1\u542c\u96c6\u6210\u8fdb\u9879\u53d1\u7968\u4fe1\u606f\uff1a{}", (Object)JsonUtils.writeObjectToFastJson((Object)sealedMessage));
        try {
            SealedMessage.Header header = sealedMessage.getHeader();
            Object obj = sealedMessage.getPayload().getObj();
            Map properties = header.getOthers();
            String message = (String)obj;
            String requestName = header.getRequestName();
            SqsQueueEnum sqsQueueEnum = null;
            switch (requestName) {
                case "purchaserInvoiceSync": {
                    sqsQueueEnum = this.purchaserInvoiceSync(properties);
                    break;
                }
                case "billPushv4": {
                    sqsQueueEnum = SqsQueueEnum.INTE_ORDER_BILL_PUSH_BAOLONG_SYNC;
                    break;
                }
                case "ant-push-message-sync": {
                    sqsQueueEnum = SqsQueueEnum.ANT_PUSH_MESSAGE_SYNC;
                    break;
                }
                default: {
                    this.logger.warn("\u672a\u77e5\u6765\u6e90\u7684\u6d88\u606f");
                    return true;
                }
            }
            this.logger.info("\u8fdb\u9879\u53d1\u7968\u540c\u6b65--\u6267\u884cSQS\u53d1\u9001 queueName:{}", (Object)sqsQueueEnum.getType());
            boolean result = this.distributeService.convergeSqsMessage(JSONObject.toJSONString((Object)properties), message, sqsQueueEnum);
            if (!result) {
                this.logger.info("\u8fdb\u9879\u53d1\u7968\u540c\u6b65--\u6267\u884cSQS\u53d1\u9001\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("\u8f6c\u53d1SQS\u8fdb\u9879\u53d1\u7968\u5f02\u5e38", (Throwable)e);
        }
        return true;
    }

    private SqsQueueEnum purchaserInvoiceSync(Map<String, String> properties) {
        String purchaserTenantId = properties.get("purchaserTenantId");
        SqsQueueEnum sqsQueueEnum = SqsQueueEnum.MIDPUR_ANT_PUR_INVOICE_SYNC;
        if (StringUtils.isNotBlank((CharSequence)this.purchaserTenantIds) && Arrays.asList(this.purchaserTenantIds.split("_")).contains(purchaserTenantId)) {
            sqsQueueEnum = SqsQueueEnum.MIDPUR_ANT_SELLER_INVOICE_SYNC;
            if (StringUtils.isNotBlank((CharSequence)this.wilmar) && Arrays.asList(this.wilmar.split("_")).contains(purchaserTenantId)) {
                sqsQueueEnum = SqsQueueEnum.INTE_ANT_PURCHASER_INVOICE_SYNC;
            }
            if (StringUtils.isNotBlank((CharSequence)this.baolong) && Arrays.asList(this.baolong.split("_")).contains(purchaserTenantId)) {
                sqsQueueEnum = SqsQueueEnum.INTE_ANT_PURCHASER_INVOICE_BAOLONG_SYNC;
            }
        }
        return sqsQueueEnum;
    }
}

