/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.distribute.listener.sqs.salesbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.distribute.bean.BillStatusChangeModel;
import com.xforceplus.ant.distribute.enums.SqsQueueEnum;
import com.xforceplus.ant.distribute.service.DistributeService;
import com.xforceplus.xplat.aws.SqsData;
import com.xforceplus.xplat.aws.spring.annotation.SQSListener;
import com.xforceplus.xplat.aws.sqs.listener.AbsSQSListener;
import com.xforceplus.xplatframework.utils.json.JsonUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@SQSListener(queueName="inte-ant-settlement-status", attributeAll=true)
public class BillCheckResultSqsListener
extends AbsSQSListener {
    private Logger logger = LoggerFactory.getLogger(BillCheckResultSqsListener.class);
    @Autowired
    DistributeService distributeService;

    public boolean cusListener(SqsData sqsData) {
        this.logger.info("BillCheckResultSqsListener pro:{} - body:{}", (Object)sqsData.getProperties(), (Object)sqsData.getMsg());
        try {
            JSONObject properties = JSON.parseObject((String)sqsData.getProperties());
            List billStatusChangeModels = JsonUtils.writeJsonToListObject((String)sqsData.getMsg(), BillStatusChangeModel.class);
            if (CollectionUtils.isEmpty((Collection)billStatusChangeModels)) {
                return true;
            }
            Map<String, List<BillStatusChangeModel>> taxModels = billStatusChangeModels.stream().collect(Collectors.groupingBy(BillStatusChangeModel::getSellerTaxNo));
            for (Map.Entry<String, List<BillStatusChangeModel>> taxModel : taxModels.entrySet()) {
                properties.put("companyTaxNo", (Object)taxModel.getKey());
                boolean result = this.distributeService.convergeSqsMessage(properties.toJSONString(), JSONObject.toJSONString(taxModel.getValue()), SqsQueueEnum.INTE_ANT_BILL_CHECK_RESULT);
                if (result) continue;
                this.logger.info("BillCheckResultSqsListener--\u6267\u884cSQS\u53d1\u9001\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("BillCheckResultSqsListener result error : ", (Throwable)e);
            return false;
        }
        return true;
    }
}

