/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.distribute.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.coop.feign.domain.CoopCanaryHolder;
import com.xforceplus.ant.coop.feign.domain.CoopCanaryInfo;
import com.xforceplus.ant.coop.route.client.data.utils.BaseResult;
import com.xforceplus.ant.distribute.client.CanaryRouteClient;
import com.xforceplus.ant.distribute.enums.SqsQueueEnum;
import com.xforceplus.ant.distribute.service.ExternalService;
import com.xforceplus.ant.distribute.utils.CommonTools;
import com.xforceplus.xplatframework.exception.ResultCode;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DistributeService {
    private Logger logger = LoggerFactory.getLogger(DistributeService.class);
    @Autowired
    ExternalService externalService;
    @Autowired
    CanaryRouteClient canaryRouteClient;
    @Value(value="${coop.canary.header-key:coop-canary}")
    private String canaryHeaderKey;

    public boolean convergeSqsMessage(String header, String body, SqsQueueEnum queueType) {
        try {
            com.xforceplus.ant.distribute.bean.BaseResult result;
            this.setCoopRoute(header, queueType);
            String response = this.externalService.sendToCoopService(header, body, queueType.getType(), queueType.getSource());
            if (!(CommonTools.isEmpty((String)response) || null != (result = (com.xforceplus.ant.distribute.bean.BaseResult)JsonUtils.writeFastJsonToObject((String)response, com.xforceplus.ant.distribute.bean.BaseResult.class)) && Response.OK.equals(result.getCode()))) {
                this.logger.info("\u53d1\u9001\u6d88\u606f\u5931\u8d25");
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u516c\u53f8\u7a0e\u53f7\u5931\u8d25\uff1a", (Throwable)e);
        }
        return true;
    }

    private void setCoopRoute(String header, SqsQueueEnum queueType) {
        try {
            JSONObject headerProperties = JSON.parseObject((String)header);
            String sellerTaxNo = headerProperties.getString(queueType.getCode());
            BaseResult baseResult = this.canaryRouteClient.getHeaderKey(sellerTaxNo);
            if (ResultCode.SUCCESS.code().equals(baseResult.getCode()) && null != baseResult.getResult()) {
                CoopCanaryInfo coopCanaryInfo = new CoopCanaryInfo();
                coopCanaryInfo.setHeaderKey(this.canaryHeaderKey);
                coopCanaryInfo.setCoopCanary((String)baseResult.getResult());
                CoopCanaryHolder.put((CoopCanaryInfo)coopCanaryInfo);
                this.logger.info("##### \u8bbe\u7f6e\u8bf7\u6c42header coop-route: {}", (Object)coopCanaryInfo);
            }
        }
        catch (Exception e) {
            this.logger.error("##### \u8bbe\u7f6e\u7070\u5ea6\u6807\u8bc6\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }
}

